/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.settings.FacilityTypeTemplatesPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.settings.LocationTemplatesPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.settings.OrderTextTemplatesPane;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsService;
import com.deutscheboerse.ui.jfx.util.control.AutoCompleteTextField;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;

public class TextFieldWithTemplates
extends AutoCompleteTextField<String> {
    private final SettingsService settingsService;
    private TemplatesSource templatesSource;
    private final IntegerProperty lengthLimit;
    private final SimpleBooleanProperty mandatory;
    public static final int UNLIMITED = -1;

    public TextFieldWithTemplates() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public TextFieldWithTemplates(ApplicationContext context) {
        super("");
        this.settingsService = context.getService(SettingsService.class);
        this.lengthLimit = new SimpleIntegerProperty(-1);
        this.mandatory = new SimpleBooleanProperty(false);
        this.valid.bind(this.mandatory.not().or(this.lengthProperty().greaterThan(0)).and(this.lengthLimit.isEqualTo(-1).or(this.lengthLimit.greaterThanOrEqualTo(this.lengthProperty()))));
    }

    @Override
    protected Stream<String> getSuggestions() {
        String text = this.getText();
        String upperText = text == null ? "" : text.toUpperCase();
        return this.loadSuggestions().stream().filter(s -> s.toUpperCase().contains(upperText));
    }

    private List<String> loadSuggestions() {
        List<String> templates = this.templatesSource == null ? null : this.settingsService.loadSettings(this.templatesSource.templateSettings);
        return templates == null ? Collections.emptyList() : templates;
    }

    @Override
    public void clear() {
        super.clear();
        this.setTextToDefault();
    }

    public void setTextToDefault() {
        List<String> suggestions = this.loadSuggestions();
        if (this.isVisible() && this.templatesSource != null && Boolean.TRUE.equals(this.settingsService.loadSettings(this.templatesSource.firstIsDefaultSettings)) && !suggestions.isEmpty()) {
            this.setText(suggestions.get(0));
        } else {
            this.setText("");
        }
    }

    public TemplatesSource getTemplatesSource() {
        return this.templatesSource;
    }

    public void setTemplatesSource(TemplatesSource templatesSource) {
        this.templatesSource = templatesSource;
    }

    public int getLengthLimit() {
        return this.lengthLimit.get();
    }

    public IntegerProperty lengthLimitProperty() {
        return this.lengthLimit;
    }

    public void setLengthLimit(int lengthLimit) {
        this.lengthLimit.set(lengthLimit);
    }

    public boolean getMandatory() {
        return this.mandatory.get();
    }

    public SimpleBooleanProperty mandatoryProperty() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory.set(mandatory);
    }

    public static enum TemplatesSource {
        ORDER_TEXT(OrderTextTemplatesPane.ORDER_TEMPLATES, OrderTextTemplatesPane.ORDER_TEMPLATES_FIRST_IS_DEFAULT),
        LOCATION(LocationTemplatesPane.LOCATION_TEMPLATES, LocationTemplatesPane.LOCATION_TEMPLATES_FIRST_IS_DEFAULT),
        FACILITY_TYPE(FacilityTypeTemplatesPane.FACILITY_TYPE_TEMPLATES, FacilityTypeTemplatesPane.FACILITY_TYPE_TEMPLATES_FIRST_IS_DEFAULT);

        private final SettingsService.Settings<List<String>> templateSettings;
        private final SettingsService.Settings<Boolean> firstIsDefaultSettings;

        private TemplatesSource(SettingsService.Settings<List<String>> templateSettings, SettingsService.Settings<Boolean> firstIsDefaultSettings) {
            this.templateSettings = templateSettings;
            this.firstIsDefaultSettings = firstIsDefaultSettings;
        }
    }
}

