/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.EntityAutoCompleteField;
import com.deutscheboerse.comxerv.comtrader.service.LocalService;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;

public class ValidTillField
extends EntityAutoCompleteField<DateTime> {
    private final ObjectProperty<Contract> contract;
    private final ObjectProperty<DeliveryArea> deliveryArea;
    private final ObjectProperty<Mode> mode;
    private final TimeService timeService;
    private final LocalService localService;
    private final ActiveExchange activeExchange;

    public ValidTillField() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public ValidTillField(ApplicationContext appContext) {
        super(appContext);
        this.localService = appContext.getService(LocalService.class);
        this.activeExchange = appContext.getService(ActiveExchange.class);
        this.contract = new SimpleObjectProperty<Contract>();
        this.deliveryArea = new SimpleObjectProperty<DeliveryArea>();
        this.timeService = appContext.getService(TimeService.class);
        this.mode = new SimpleObjectProperty<Mode>(Mode.FIVE_MINUTE_STEPS);
        this.mode.bind(DependentBinding.get(this::getMode, this.contract, this.deliveryArea));
        this.valid.bind((ObservableValue<? extends Boolean>)DependentBinding.get(this::computeValid, this.valueProperty(), this.disabledProperty(), this.contract));
        this.promptTextProperty().bind(DependentBinding.get(() -> {
            if (this.mode.get() != null) {
                return Util.getLabel("commons_validityDate");
            }
            return this.printDateTime(DateTime.now(this.getBackendTimeZone()));
        }, this.disabledProperty(), this.mode));
        this.setToStringConverter(this::convertToString);
    }

    public void loadValue(DateTime dateTime) {
        this.setText(this.printDateTime(dateTime));
    }

    private boolean computeValid() {
        if (this.getContract() == null || this.isDisabled()) {
            return true;
        }
        if (this.getValue() != null && this.mode.get() == Mode.FIVE_MINUTE_STEPS) {
            return ((DateTime)this.getValue()).getMinuteOfHour() % 5 == 0;
        }
        return false;
    }

    private Mode getMode() {
        return Mode.FIVE_MINUTE_STEPS;
    }

    private List<DateTime> getDates() {
        ArrayList<DateTime> dates = new ArrayList<DateTime>();
        Contract currentContract = this.getContract();
        DeliveryArea currentDeliveryArea = this.getDeliveryArea();
        if (currentContract != null && currentDeliveryArea != null) {
            DateTime expiryPoint = ((Contract)this.contract.get()).getExpiryPoint() != null ? ((Contract)this.contract.get()).getExpiryPoint() : ((Contract)this.contract.get()).getDeliveryEnd();
            Interval activePeriod = currentContract.getCompoundStatus().getActivePeriod((DeliveryArea)this.deliveryArea.get());
            if (activePeriod != null) {
                DateTime end;
                DateTime now = this.timeService.getServerTime();
                DateTime start = now.isAfter(activePeriod.getStart()) ? now : activePeriod.getStart();
                DateTime tradingPhaseEndAtExpiryDate = expiryPoint.withTime(activePeriod.getEnd().toLocalTime());
                DateTime dateTime = end = expiryPoint.isAfter(tradingPhaseEndAtExpiryDate) ? tradingPhaseEndAtExpiryDate : expiryPoint;
                if (this.mode.get() == Mode.FIVE_MINUTE_STEPS) {
                    start = start.withTime(start.getHourOfDay(), start.getMinuteOfHour(), 0, 0).minusMinutes(start.getMinuteOfHour() % 5);
                    while (start.isBefore(end)) {
                        start = start.plusMinutes(5);
                        dates.add(start);
                    }
                }
            }
        }
        return Lists.reverse(dates);
    }

    @Override
    public Stream<DateTime> getSuggestedEntities(String currentText) {
        return this.getDates().stream().filter(date -> this.convertToString((DateTime)date).startsWith(currentText));
    }

    private String convertToString(DateTime entity) {
        if (this.mode.get() == Mode.FIVE_MINUTE_STEPS) {
            return this.localService.getJodaDateFormat().printTimeInFrontDateFormat(entity);
        }
        return "";
    }

    private DateTimeZone getBackendTimeZone() {
        Exchange exchange = this.activeExchange.getActiveExchange().get();
        if (exchange != null) {
            return exchange.getSystemInfo().getTimeZone();
        }
        return DateTimeZone.getDefault();
    }

    @Override
    public Optional<DateTime> getEntity(String currentText) {
        return Optional.ofNullable(this.parseDateTime(currentText));
    }

    private DateTime parseDateTime(String string) {
        return this.localService.getJodaDateFormat().parseTimeInFrontDateFormat(string, this.getBackendTimeZone());
    }

    private String printDateTime(DateTime dateTime) {
        return this.localService.getJodaDateFormat().printTimeInFrontDateFormat(dateTime);
    }

    public Contract getContract() {
        return (Contract)this.contract.get();
    }

    public ObjectProperty<Contract> contractProperty() {
        return this.contract;
    }

    public void setContract(Contract contract) {
        this.contract.set(contract);
    }

    public DeliveryArea getDeliveryArea() {
        return (DeliveryArea)this.deliveryArea.get();
    }

    public ObjectProperty<DeliveryArea> deliveryAreaProperty() {
        return this.deliveryArea;
    }

    public void setDeliveryArea(DeliveryArea deliveryArea) {
        this.deliveryArea.set(deliveryArea);
    }

    private static enum Mode {
        FIVE_MINUTE_STEPS;

    }
}

