/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control.contextmenu;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.CommonOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.contextmenu.LazyOrderContextMenu;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.contextmenu.OrderbookContextMenuFactory;
import com.deutscheboerse.comxerv.comtrader.jfx.components.icon.IconView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.image.ContextMenuIcon;
import com.deutscheboerse.comxerv.comtrader.jfx.service.event.MarketSelectionEvent;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.action.OrderActionsService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;

@Singleton
public class OrderbookContextMenuFactoryImpl
implements OrderbookContextMenuFactory {
    private final ApplicationContext appContext;

    @Inject
    public OrderbookContextMenuFactoryImpl(ApplicationContext appContext) {
        this.appContext = appContext;
    }

    @Override
    public ContextMenu createOrderbookContextMenu(CommonOrderbookEntry entry, OrderActionsService.PreparedOrderQuantitySelector quantitySelector) {
        return new OrderbookEntryContextMenu(this.appContext, entry, quantitySelector);
    }

    private static class OrderbookEntryContextMenu
    extends LazyOrderContextMenu {
        private final OrderActionsService orderActionsService;
        private final CommonOrderbookEntry entry;
        private final OrderActionsService.PreparedOrderQuantitySelector quantitySelector;

        public OrderbookEntryContextMenu(ApplicationContext appContext, CommonOrderbookEntry entry, OrderActionsService.PreparedOrderQuantitySelector quantitySelector) {
            super(appContext);
            this.entry = entry;
            this.quantitySelector = quantitySelector;
            this.orderActionsService = appContext.getService(OrderActionsService.class);
        }

        @Override
        protected List<? extends MenuItem> rebuildItems() {
            ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
            Optional<Order> originalOrder = this.orderActionsService.getOriginalOrder(this.entry);
            if (this.ownQuantityLookupService != null && originalOrder.isPresent() && this.ownQuantityLookupService.isOwnOrder(originalOrder.get())) {
                menuItems.add(this.deactivateMenuItem(List.of(originalOrder.get())));
                menuItems.add(this.modifyMenuItem(originalOrder.get()));
                menuItems.add(this.deleteMenuItem(List.of(originalOrder.get())));
            }
            Order preparedOrder = this.orderActionsService.createOrderFromOrderbookEntry(this.entry, this.quantitySelector);
            Order oppositePreparedOrder = new Order(preparedOrder);
            oppositePreparedOrder.setDirection(preparedOrder.getDirection().reverse());
            if (this.entry.getOrderbook().getContract().getProduct().isLiftOrderProduct()) {
                menuItems.addAll(this.liftMenuItem(oppositePreparedOrder));
            } else {
                menuItems.addAll(this.matchMenuItem(oppositePreparedOrder));
            }
            menuItems.addAll(this.addMenuItem(preparedOrder));
            return menuItems;
        }

        private List<MenuItem> liftMenuItem(Order preparedOrder) {
            ArrayList<MenuItem> list = new ArrayList<MenuItem>();
            Set<BalancingGroup> balancingGroups = this.getPossibleBalancingGroups(preparedOrder.getContract(), preparedOrder.getDeliveryArea());
            for (BalancingGroup balancingGroup : balancingGroups) {
                String label = balancingGroups.size() == 1 ? Util.getLabel("commons_liftOrder") : Util.getLabel("orderContextMenu_liftAs", balancingGroup.getDisplayName());
                MenuItem menuItem = new MenuItem(label);
                menuItem.setGraphic(new IconView(ContextMenuIcon.MATCH.getIconStyleClass()));
                menuItem.setOnAction(event -> this.orderPopup.showLiftOrderPopup(preparedOrder, menuItem.getGraphic()));
                list.add(menuItem);
            }
            return list;
        }

        private List<MenuItem> matchMenuItem(Order preparedOrder) {
            ArrayList<MenuItem> list = new ArrayList<MenuItem>();
            Set<BalancingGroup> balancingGroups = this.getPossibleBalancingGroups(preparedOrder.getContract(), preparedOrder.getDeliveryArea());
            for (BalancingGroup balancingGroup : balancingGroups) {
                String label = balancingGroups.size() == 1 ? Util.getLabel("commons_matchOrder") : Util.getLabel("orderContextMenu_matchAs", balancingGroup.getDisplayName());
                MenuItem menuItem = new MenuItem(label);
                menuItem.setGraphic(new IconView(ContextMenuIcon.MATCH.getIconStyleClass()));
                menuItem.setOnAction(event -> {
                    MarketSelectionEvent selectionEvent = new MarketSelectionEvent(preparedOrder);
                    this.eventBus.post(selectionEvent);
                    if (!selectionEvent.wasProcessed()) {
                        this.orderPopup.showExtendedOrderPopup(preparedOrder, false, menuItem.getGraphic());
                    }
                });
                list.add(menuItem);
            }
            return list;
        }
    }
}

