/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.filter.ui;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.LabeledBottomToolbarButton;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.FilteredTableView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.TableFilter;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.ui.FilterComponent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.icon.IconView;
import com.deutscheboerse.comxerv.comtrader.jfx.util.UtilityStages;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.StageUtil;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.fxml.FXML;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.stage.Stage;

public class FilterPopupButton<S extends BroadcastEntity>
extends LabeledBottomToolbarButton {
    private final Stage stage;
    private final ApplicationContext appContext;
    private final StringProperty title;
    private FilteredTableView<S> filteredTableView;
    private StageUtil stageUtil;

    public FilterPopupButton(ApplicationContext appContext) {
        this.appContext = appContext;
        this.stage = appContext.getService(UtilityStages.class).withKey(FilterPopupButton.class.getName()).get();
        this.stageUtil = appContext.getService(StageUtil.class);
        this.title = new SimpleStringProperty();
        FXMLLoaderWithContext.loadCustomComponent(appContext, this);
        this.setShowLabel(false);
        this.setText(Util.getLabel("commons_filter"));
        this.setIconStyleClass("button-filter");
    }

    public FilterPopupButton() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public void initialize(FilteredTableView<S> filteredTableView) {
        this.filteredTableView = filteredTableView;
        this.filteredTableView.customFilterProperty().addListener((observable2, oldValue, newValue) -> this.customFilterChanged((TableFilter<S>)newValue));
        this.customFilterChanged(filteredTableView.getCustomFilter());
    }

    private void customFilterChanged(TableFilter<S> newFilter) {
        this.setIconStyleClass(newFilter.getFilteredColumns().isEmpty() ? "button-filter" : "button-filter-applied");
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title.set(title);
    }

    @Override
    public Node getPreviewForConfigTable() {
        Label preview = new Label(null, new IconView("button-filter"));
        preview.setDisable(true);
        return preview;
    }

    @FXML
    public void showFilterComponent() {
        FilterComponent<S> filterComponent = new FilterComponent<S>(this.appContext, this.filteredTableView);
        this.stage.setScene(new Scene(filterComponent));
        Point2D middleScreenCoordinates = this.stageUtil.getMiddleScreenCoordinates(this);
        this.stage.setX(middleScreenCoordinates.getX() - filterComponent.getPrefWidth() / 2.0);
        this.stage.setY(middleScreenCoordinates.getY() - filterComponent.getPrefHeight() / 2.0);
        this.stage.setTitle(this.title.getValue());
        this.stage.show();
    }
}

