/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.login;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.session.ConnectionParametersWithFallback;
import com.deutscheboerse.comxerv.comtrader.entities.session.DisconnectAction;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import javafx.fxml.FXML;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.Pane;

public class DisconnectActionPane
extends Pane {
    @FXML
    private ToggleGroup disconnectActionToggleGroup;
    @FXML
    private RadioButton radioButtonDeactivateUser;
    @FXML
    private RadioButton radioButtonDeactivateAccount;
    @FXML
    private RadioButton radioButtonNoAction;

    public DisconnectActionPane() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    protected DisconnectActionPane(ApplicationContext applicationContext) {
        FXMLLoaderWithContext.loadCustomComponent(applicationContext, this);
    }

    protected void loadConnectionParameters(ConnectionParametersWithFallback connectionParameters) {
        switch (connectionParameters.getDisconnectAction()) {
            case NO: {
                this.disconnectActionToggleGroup.selectToggle(this.radioButtonNoAction);
                break;
            }
            case DEACT_USER_ORDRS: {
                this.disconnectActionToggleGroup.selectToggle(this.radioButtonDeactivateUser);
                break;
            }
            case DEACT_ACCT_ORDRS: {
                this.disconnectActionToggleGroup.selectToggle(this.radioButtonDeactivateAccount);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal disconnect action " + String.valueOf(connectionParameters.getDisconnectAction()));
            }
        }
        this.disconnectActionToggleGroup.selectedToggleProperty().addListener((observableValue, toggle, toggle2) -> {
            if (this.disconnectActionToggleGroup.getSelectedToggle() != null) {
                if (this.radioButtonNoAction.equals(this.disconnectActionToggleGroup.getSelectedToggle())) {
                    connectionParameters.setDisconnectAction(DisconnectAction.NO);
                } else if (this.radioButtonDeactivateUser.equals(this.disconnectActionToggleGroup.getSelectedToggle())) {
                    connectionParameters.setDisconnectAction(DisconnectAction.DEACT_USER_ORDRS);
                } else {
                    connectionParameters.setDisconnectAction(DisconnectAction.DEACT_ACCT_ORDRS);
                }
            }
        });
    }

    public ToggleGroup getDisconnectActionToggleGroup() {
        return this.disconnectActionToggleGroup;
    }

    public RadioButton getRadioButtonNoAction() {
        return this.radioButtonNoAction;
    }
}

