/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.login;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.session.ConnectionParametersWithFallback;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.m7.trading.api.v6.ThrottlingMemberActionType;
import com.deutscheboerse.m7.trading.api.v6.ThrottlingUserActionType;
import javafx.fxml.FXML;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.Pane;

public class OnThrottlingPane
extends Pane {
    @FXML
    private ToggleGroup throttlingUserActionToggleGroup;
    @FXML
    private ToggleGroup throttlingMemberActionToggleGroup;
    @FXML
    private RadioButton radioButtonUserNoAction;
    @FXML
    private RadioButton radioButtonUserHibernateUserOrders;
    @FXML
    private RadioButton radioButtonUserHibernateBalancingGroupOrders;
    @FXML
    private RadioButton radioButtonMemberNoAction;
    @FXML
    private RadioButton radioButtonMemberHibernateMemberOrders;

    public OnThrottlingPane() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    protected OnThrottlingPane(ApplicationContext applicationContext) {
        FXMLLoaderWithContext.loadCustomComponent(applicationContext, this);
    }

    protected void loadConnectionParameters(ConnectionParametersWithFallback connectionParameters) {
        switch (connectionParameters.getThrottlingUserAction()) {
            case NONE_USER_ORDERS: {
                this.throttlingUserActionToggleGroup.selectToggle(this.radioButtonUserNoAction);
                break;
            }
            case HIBE_USER_ORDERS: {
                this.throttlingUserActionToggleGroup.selectToggle(this.radioButtonUserHibernateUserOrders);
                break;
            }
            case HIBE_BG_ORDERS: {
                this.throttlingUserActionToggleGroup.selectToggle(this.radioButtonUserHibernateBalancingGroupOrders);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal throttling user action " + String.valueOf(connectionParameters.getThrottlingUserAction()));
            }
        }
        this.throttlingUserActionToggleGroup.selectedToggleProperty().addListener((observableValue, toggle, toggle2) -> {
            if (this.throttlingUserActionToggleGroup.getSelectedToggle() != null) {
                if (this.radioButtonUserNoAction.equals(this.throttlingUserActionToggleGroup.getSelectedToggle())) {
                    connectionParameters.setThrottlingUserAction(ThrottlingUserActionType.NONE_USER_ORDERS);
                } else if (this.radioButtonUserHibernateUserOrders.equals(this.throttlingUserActionToggleGroup.getSelectedToggle())) {
                    connectionParameters.setThrottlingUserAction(ThrottlingUserActionType.HIBE_USER_ORDERS);
                } else {
                    connectionParameters.setThrottlingUserAction(ThrottlingUserActionType.HIBE_BG_ORDERS);
                }
            }
        });
        switch (connectionParameters.getThrottlingMemberAction()) {
            case NONE_MBR_ORDERS: {
                this.throttlingMemberActionToggleGroup.selectToggle(this.radioButtonMemberNoAction);
                break;
            }
            case HIBE_MBR_ORDERS: {
                this.throttlingMemberActionToggleGroup.selectToggle(this.radioButtonMemberHibernateMemberOrders);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal throttling member action " + String.valueOf(connectionParameters.getThrottlingMemberAction()));
            }
        }
        this.throttlingMemberActionToggleGroup.selectedToggleProperty().addListener((observableValue, toggle, toggle2) -> {
            if (this.throttlingMemberActionToggleGroup.getSelectedToggle() != null) {
                if (this.radioButtonMemberNoAction.equals(this.throttlingMemberActionToggleGroup.getSelectedToggle())) {
                    connectionParameters.setThrottlingMemberAction(ThrottlingMemberActionType.NONE_MBR_ORDERS);
                } else {
                    connectionParameters.setThrottlingMemberAction(ThrottlingMemberActionType.HIBE_MBR_ORDERS);
                }
            }
        });
    }
}

