/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.market;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.type.BasketRestriction;
import com.deutscheboerse.comxerv.comtrader.jfx.components.market.AbstractMarketSubmitter;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandler;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrderSender;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrdersToSend;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.RequestType;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class OwnMarketSubmitter
extends AbstractMarketSubmitter {
    private final OrderSender orderSender;

    public OwnMarketSubmitter(ApplicationContext appContext) {
        super(appContext);
        this.orderSender = appContext.getService(OrderSender.class);
    }

    @Override
    AtomicInteger getAwaitingResponses(List<Order> ordersToSend) {
        return new AtomicInteger(ordersToSend.size());
    }

    @Override
    void sendOrder(ResponseHandler responseHandler, List<Order> ordersToSend) {
        this.orderSender.sendOrder(new OrdersToSend(ordersToSend, RequestType.MODIFY, BasketRestriction.NONE, responseHandler, null), true);
    }
}

