/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntries;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.BatchUpdateAdapter;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.BatchUpdateListener;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.WeakBatchUpdateListener;
import com.deutscheboerse.comxerv.comtrader.entities.property.binding.LongDisplayValueStringBinding;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.AbstractAreaChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.FlashingLabel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.AbstractOrderbookPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.CloseRemoveOrderbookCallBack;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideExcelConfiguration;
import com.deutscheboerse.ui.jfx.util.binding.WeakObservableValue;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Set;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;

@OverrideExcelConfiguration(overrideId="AdminOrderbookPane", defaultHeadersStrategy="com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.excel.AdminOrderbookPaneExcelHeadersStrategy", defaultRowsStrategy="com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.excel.AdminOrderbookPaneExcelRowsStrategy")
public class AdminOrderbookPane
extends AbstractOrderbookPane {
    @FXML
    private FlashingLabel totalText;
    @FXML
    private FlashingLabel buyText;
    @FXML
    private FlashingLabel sellText;
    private OpenCapital openBuysCapital;
    private OpenCapital openSellsCapital;

    public AdminOrderbookPane(ApplicationContext appContext, Orderbook initialOrderbook, CloseRemoveOrderbookCallBack closeRemoveOrderbookCallBack, ObservableValue<Integer> rowLimit, AbstractAreaChoiceBox switchAllDaChoiceBox) {
        super(appContext, initialOrderbook, closeRemoveOrderbookCallBack, rowLimit, switchAllDaChoiceBox);
        FXMLLoaderWithContext.loadCustomComponent(appContext, this);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.name.setOnMouseClicked(null);
    }

    @Override
    protected void loadOrderbookProperties(Orderbook currentOrderbookValue) {
        super.loadOrderbookProperties(currentOrderbookValue);
        this.loadTotal(currentOrderbookValue);
        this.loadOpenBuySell(currentOrderbookValue);
    }

    private void loadTotal(Orderbook currentOrderbookValue) {
        if (currentOrderbookValue != null) {
            this.totalText.textProperty().bind(new WeakObservableValue<String>(new LongDisplayValueStringBinding(currentOrderbookValue.totalTradedQtyProperty(), true, "-")));
        } else {
            this.totalText.textProperty().unbind();
        }
    }

    private void loadOpenBuySell(Orderbook currentOrderbookValue) {
        if (currentOrderbookValue != null) {
            this.openBuysCapital = new OpenCapital(currentOrderbookValue, true);
            this.buyText.textProperty().bind(this.openBuysCapital.textValueProperty());
            this.openSellsCapital = new OpenCapital(currentOrderbookValue, false);
            this.sellText.textProperty().bind(this.openSellsCapital.textValueProperty());
        } else {
            this.openBuysCapital = null;
            this.buyText.textProperty().unbind();
            this.openSellsCapital = null;
            this.sellText.textProperty().unbind();
        }
    }

    static class OpenCapital {
        private StringProperty textValue = new SimpleStringProperty("");
        private BatchUpdateListener<OrderbookEntry> entriesListener;

        OpenCapital(Orderbook orderbook, boolean buysOrSells) {
            Product product = orderbook.getContract().getProduct();
            final int shift = product.getQuantityDecimalShift() + product.getPriceDecimalShift();
            final BigDecimal coefficient = BigDecimal.valueOf(orderbook.getContract().getDeliveryUnits());
            final OrderbookEntries orderbookEntries = buysOrSells ? orderbook.getBuys() : orderbook.getSells();
            this.entriesListener = new BatchUpdateAdapter<OrderbookEntry>(){

                @Override
                public BatchUpdateListener.NotificationResult batchFinished() {
                    LongDisplayValue openCapital = this.computeOpenCapital(orderbookEntries.getEntries(), shift, coefficient);
                    String value = new LongDisplayValueStringBinding(new SimpleObjectProperty<LongDisplayValue>(openCapital), true, "-").get();
                    textValue.setValue(value);
                    return BatchUpdateListener.NotificationResult.RETAIN_LISTENER;
                }
            };
            orderbookEntries.addListener((BatchUpdateListener<OrderbookEntry>)new WeakBatchUpdateListener<OrderbookEntry>(this.entriesListener));
            this.entriesListener.batchFinished();
        }

        LongDisplayValue computeOpenCapital(Set<OrderbookEntry> set, int shift, BigDecimal coefficient) {
            if (set.isEmpty()) {
                return null;
            }
            BigDecimal sum = BigDecimal.ZERO;
            for (OrderbookEntry entry : set) {
                BigDecimal grossValue = BigDecimal.valueOf(entry.getQuantity().getValue() * entry.getPrice().getValue(), shift);
                sum = sum.add(grossValue.multiply(coefficient));
            }
            return new LongDisplayValue(sum.setScale(shift, RoundingMode.HALF_UP));
        }

        StringProperty textValueProperty() {
            return this.textValue;
        }
    }
}

