/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.contract;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ContractField;
import com.deutscheboerse.comxerv.comtrader.service.BlockContractService;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;

public abstract class BlockContractField
extends ContractField {
    protected final BlockContractService blockContractService;
    private final ObjectProperty<Contract> other = new SimpleObjectProperty<Object>(null);
    private final ObjectProperty<Product> blockProduct;

    public BlockContractField(ApplicationContext appContext) {
        super(appContext);
        this.other.addListener(this::valueOrOtherOrBlockProductChanged);
        this.blockProduct = new SimpleObjectProperty<Product>();
        this.valueProperty().addListener(this::valueOrOtherOrBlockProductChanged);
        this.blockProduct.addListener(this::valueOrOtherOrBlockProductChanged);
        this.blockContractService = appContext.getService(BlockContractService.class);
    }

    private void valueOrOtherOrBlockProductChanged(Observable observable2) {
        this.setValid(this.calculateValid());
    }

    @Override
    public boolean calculateValid() {
        Contract other = this.getOther();
        Contract contract = (Contract)this.getValue();
        Product blockProduct = this.getBlockProduct();
        return other != null && contract != null && blockProduct != null && this.isConsistentWithOther(contract, other, blockProduct);
    }

    protected abstract boolean isConsistentWithOther(Contract var1, Contract var2, Product var3);

    protected boolean isFrontAndRearContractConsistent(Contract frontContract, Contract rearContract, Product blockProduct) {
        return this.blockContractService.isFrontAndRearContractAndBlockProductConsistent(frontContract, rearContract, blockProduct);
    }

    @Override
    public boolean filterValue(Contract contract) {
        return this.blockContractService.isValidBlockContractSide(contract);
    }

    public boolean hasOnlyOneSuggestion() {
        return this.getSuggestions().count() == 1L;
    }

    public Product getBlockProduct() {
        return (Product)this.blockProduct.get();
    }

    public ObjectProperty<Product> blockProductProperty() {
        return this.blockProduct;
    }

    public void setBlockProduct(Product blockProduct) {
        this.blockProduct.set(blockProduct);
    }

    public Contract getOther() {
        return (Contract)this.other.get();
    }

    public ObjectProperty<Contract> otherProperty() {
        return this.other;
    }

    public void setOther(Contract other) {
        this.other.set(other);
    }
}

