/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.settings;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.NumberTextField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.alerting.AlertingColorPicker;
import com.deutscheboerse.comxerv.comtrader.service.alerting.AlertingColor;
import com.deutscheboerse.comxerv.comtrader.service.alerting.AlertingSetting;
import com.google.common.eventbus.EventBus;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;

public class AlertingSettingEntry
extends HBox {
    private String productId;
    @FXML
    private CheckBox enabled;
    @FXML
    private NumberTextField alertingTimer;
    @FXML
    private AlertingColorPicker alertingColor;
    @FXML
    private Label productName;

    public AlertingSettingEntry(ApplicationContext appContext, String productId, String productName, AlertingSetting alertingEvent) {
        this(appContext, productId, productName, alertingEvent.isEnabled(), alertingEvent.getOffset().toString(), alertingEvent.getColor());
    }

    public AlertingSettingEntry(ApplicationContext appContext, String productId, String productName, boolean enabled, String alertingTimer, AlertingColor alertingColor) {
        appContext.getService(EventBus.class).register(this);
        FXMLLoaderWithContext.loadCustomComponent(appContext, this);
        this.productId = productId;
        this.productName.setText(productName);
        this.enabled.setSelected(enabled);
        this.alertingTimer.setText(alertingTimer);
        this.alertingColor.setValue(alertingColor);
    }

    public void enable() {
        this.enabled.setSelected(true);
    }

    public void disable() {
        this.enabled.setSelected(false);
    }

    public void setAlertingTimer(String alertingTimer) {
        this.alertingTimer.setText(alertingTimer);
    }

    public void setAlertingColor(AlertingColor alertingColor) {
        this.alertingColor.setValue(alertingColor);
    }

    public String getProductName() {
        return this.productName.getText();
    }

    public boolean getEnabled() {
        return this.enabled.isSelected();
    }

    public Integer getAlertingTimer() {
        return Integer.parseInt(this.alertingTimer.getText());
    }

    public AlertingColor getAlertingColor() {
        return this.alertingColor.getValue();
    }

    public String getProductId() {
        return this.productId;
    }
}

