/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.CommonOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.jfx.service.trade.TradingActionService;
import com.deutscheboerse.comxerv.comtrader.jfx.util.DragAndDropService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.action.OrderActionsService;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradingAction;
import java.util.Collections;
import java.util.function.Supplier;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;

public class OrderbookEntryTableCellClickHandler
implements EventHandler<MouseEvent> {
    private final Supplier<CommonOrderbookEntry> entry;
    private final Node parent;
    private final TradingActionService tradingActionService;
    private final ApplicationContext appContext;
    private final OrderActionsService.PreparedOrderQuantitySelector quantitySelector;
    private final OrderActionsService orderActionsService;

    public OrderbookEntryTableCellClickHandler(ApplicationContext appContext, Supplier<CommonOrderbookEntry> entry, Node parent, OrderActionsService.PreparedOrderQuantitySelector quantitySelector) {
        this.appContext = appContext;
        this.entry = entry;
        this.parent = parent;
        this.quantitySelector = quantitySelector;
        this.orderActionsService = appContext.getService(OrderActionsService.class);
        this.tradingActionService = appContext.getService(TradingActionService.class);
    }

    public OrderbookEntryTableCellClickHandler(ApplicationContext appContext, CommonOrderbookEntry entry, Node parent, OrderActionsService.PreparedOrderQuantitySelector quantitySelector) {
        this(appContext, () -> entry, parent, quantitySelector);
    }

    @Override
    public void handle(MouseEvent mouseEvent) {
        CommonOrderbookEntry currentEntry = this.entry.get();
        if (mouseEvent.isDragDetect() && this.parent != null) {
            try {
                Dragboard dragboard = this.parent.startDragAndDrop(TransferMode.ANY);
                Order preparedOrder = this.orderActionsService.createOrderFromOrderbookEntry(currentEntry, this.quantitySelector);
                if (this.tradingActionService.getAction(mouseEvent, currentEntry.getType()) == TradingAction.MATCH) {
                    preparedOrder.setDirection(preparedOrder.getDirection().reverse());
                }
                this.appContext.getService(DragAndDropService.class).setOrderbookEntryList(dragboard, Collections.singletonList(preparedOrder));
            }
            catch (IllegalStateException | NullPointerException runtimeException) {
                // empty catch block
            }
            mouseEvent.consume();
        }
        this.tradingActionService.doAction(mouseEvent, currentEntry, this.quantitySelector);
    }
}

