/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.trade;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.entities.type.TradeState;
import com.deutscheboerse.comxerv.comtrader.jfx.components.FXMLBorderPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ButtonWithIcon;
import com.deutscheboerse.comxerv.comtrader.jfx.components.event.ReactOnButtonFocusKeyListener;
import com.deutscheboerse.comxerv.comtrader.jfx.service.csv.ImportExportService;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradeProcessingUserInterface;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;

public class TradesPopupPanel
extends FXMLBorderPane {
    private final Consumer<TradeState> selectedUserAction;
    @FXML
    private Label tradesLabel;
    @FXML
    private Label questionLabel;
    @FXML
    private HBox buttonGroupHBox;

    public TradesPopupPanel(ApplicationContext appContext, List<FullTrade> trades, Consumer<TradeState> selectedUserAction, TradeProcessingUserInterface.Mode tradePopupMode) {
        super(appContext);
        this.selectedUserAction = selectedUserAction;
        this.loadFxml();
        this.tradesLabel.setText(TradesPopupPanel.tradeConfirmationText(trades));
        this.setOnKeyPressed(new ReactOnButtonFocusKeyListener());
        this.buttonGroupHBox.getChildren().addAll((Collection<Node>)(TradeProcessingUserInterface.Mode.CANCEL == tradePopupMode ? this.cancellationButtons(trades) : this.defaultButtons(trades.get(0).getTradeState())));
        String questionParameter = TradeProcessingUserInterface.Mode.CANCEL == tradePopupMode || TradeState.CANCEL_REQUESTED.equals(trades.get(0).getTradeState()) ? Util.getLabel("commons_cancel") : Util.getLabel("commons_recall");
        this.questionLabel.setText(Util.getLabel("tradesCancellationConfirmationPanel_tradeQuestion", questionParameter));
    }

    private List<Button> defaultButtons(TradeState tradeState) {
        ButtonWithIcon acceptButton = new ButtonWithIcon(Util.getLabel("commons_acceptLabel"), "button-accept");
        ButtonWithIcon rejectButton = new ButtonWithIcon(Util.getLabel("commons_reject"), "button-reject");
        ButtonWithIcon cancelButton = new ButtonWithIcon(Util.getLabel("commons_cancel"), "button-close");
        if (tradeState == TradeState.CANCEL_REQUESTED) {
            acceptButton.setOnAction(this.createActionEvent(TradeState.CANCELLED));
            rejectButton.setOnAction(this.createActionEvent(TradeState.CANCEL_REJECTED));
        } else {
            acceptButton.setOnAction(this.createActionEvent(TradeState.RECALL_GRANTED));
            rejectButton.setOnAction(this.createActionEvent(TradeState.RECALL_REJECTED));
        }
        cancelButton.setOnAction(this.createActionEvent(null));
        cancelButton.setCancelButton(true);
        return List.of(acceptButton, rejectButton, cancelButton);
    }

    private List<Button> cancellationButtons(List<FullTrade> trades) {
        ButtonWithIcon yesButton = new ButtonWithIcon(Util.getLabel("commons_yes"), "button-accept");
        ButtonWithIcon noButton = new ButtonWithIcon(Util.getLabel("commons_no"), "button-reject");
        ButtonWithIcon exportButton = new ButtonWithIcon(Util.getLabel("commons_exportAll"), "button-export");
        yesButton.setOnAction(this.createActionEvent(TradeState.CANCELLED));
        noButton.setOnAction(this.createActionEvent(null));
        exportButton.setOnAction(a -> this.exportTradeCsv(trades));
        noButton.setCancelButton(true);
        return List.of(yesButton, noButton, exportButton);
    }

    private void exportTradeCsv(List<FullTrade> trades) {
        ImportExportService exportService = this.getAppContext().getService(ImportExportService.class);
        String fileName = DateTime.now().toString("yyyy-MM-dd_HHmmSS") + "_trades_to_cancel.csv";
        exportService.exportHalftradesToCsvFile(trades.stream().flatMap(FullTrade::allHalfTrades), this.getScene().getWindow(), fileName);
    }

    @Nonnull
    private static String tradeConfirmationText(List<FullTrade> trades) {
        int tradeIdLimit = 10;
        String tradeIds = trades.stream().map(t -> String.valueOf(t.getId())).limit(tradeIdLimit).collect(Collectors.joining(", "));
        Object tradeIdsText = trades.size() > tradeIdLimit ? tradeIds + "..." : tradeIds;
        return Util.getLabel("tradeCancellationConfirmationPanel_tradeIds", trades.size(), tradeIdsText);
    }

    private EventHandler<ActionEvent> createActionEvent(TradeState tradeState) {
        return event -> this.selectedUserAction.accept(tradeState);
    }
}

