/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service.manual;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.google.inject.Inject;
import java.awt.Desktop;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ManualService {
    private static final String CUSTOMER_PORTAL_URL_APPLICATION_PROPERTY = "deploymentUrl";
    private static final String DOCUMENTATION_SUFFIX = "/documentation/";
    private static final String LOCALHOST_DOCUMENTATION_URL = "https://englobjci1.deutsche-boerse.de/job/Energy/view/M7%20Trading/job/m7-product-ci/job/develop/M7P_20Documentation/";
    private final UserAlertService userAlertService;
    private final ExecutorService executorService;
    private final ApplicationContext applicationContext;

    @Inject
    public ManualService(UserAlertService userAlertService, @WorkerExecutor ExecutorService executorService, ApplicationContext applicationContext) {
        this.userAlertService = userAlertService;
        this.executorService = executorService;
        this.applicationContext = applicationContext;
    }

    public void showManual() {
        this.executorService.execute(this::openManual);
    }

    private void openManual() {
        try {
            Desktop desktop = Desktop.getDesktop();
            Object documentationUrl = this.applicationContext.getService(ApplicationConfigurationService.class).getApplicationProperty(CUSTOMER_PORTAL_URL_APPLICATION_PROPERTY) + DOCUMENTATION_SUFFIX;
            if (((String)documentationUrl).contains("localhost")) {
                documentationUrl = LOCALHOST_DOCUMENTATION_URL;
            }
            desktop.browse(URI.create((String)documentationUrl));
        }
        catch (Exception e) {
            FxUtil.runInFxThread(() -> this.showError(e));
        }
    }

    private void showError(Exception e) {
        this.userAlertService.showConfirmationDialog(Util.getLabel("commons_error"), e.getMessage(), ExceptionUtils.getStackTrace(e), UserAlertService.Flag.ERROR);
    }
}

