/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service.sound;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.AbstractDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.jfx.service.sound.SoundEvent;
import com.deutscheboerse.comxerv.comtrader.jfx.service.sound.SoundEventType;
import com.deutscheboerse.comxerv.comtrader.jfx.service.sound.SoundService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.sound.SoundType;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.event.EntityLoadingFinishedEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.EntityLoadingStartedEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.TradeRecallRequestedMessageEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.UrgentMessageEvent;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.FailedOrderSubmissionEvent;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsService;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.scene.media.AudioClip;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SoundServiceImpl
implements SoundService {
    private static final Logger LOG = LoggerFactory.getLogger(SoundServiceImpl.class);
    private final Map<SoundType, AudioClip> soundsCache;
    private static final String SOUNDS_PATH = "/com/deutscheboerse/comxerv/comtrader/jfx/sounds/";
    private static final String SOUNDS_PROPERTIES_PATH = "/com/deutscheboerse/comxerv/comtrader/jfx/sounds/sounds.properties";
    private final SettingsService settingsService;
    private final TimeService timeService;
    private DateTime serverTimeAtStartOfDay;
    private final AtomicInteger currentLoadingProcesses = new AtomicInteger(1);

    @Inject
    public SoundServiceImpl(ApplicationContext appContext) {
        this.soundsCache = new ConcurrentHashMap<SoundType, AudioClip>();
        this.settingsService = appContext.getService(SettingsService.class);
        this.timeService = appContext.getService(TimeService.class);
        appContext.getService(ExecutorService.class, WorkerExecutor.class).submit(this::initSoundsCache);
        appContext.getLargeDataModel(FullTrade.class).registerHencePostOperationListener(new AbstractDataModelListener<FullTrade>(){

            @Override
            public DataModelListener.NotificationResult notifyAdd(FullTrade trade) {
                if (!trade.getTimeStamp().isBefore(SoundServiceImpl.this.serverTimeAtStartOfDay)) {
                    SoundServiceImpl.this.tradeAdded(trade);
                }
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyRemoveAll() {
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }
        });
        appContext.getService(EventBus.class).register(this);
    }

    private void tradeAdded(FullTrade trade) {
        SoundEvent soundEvent = new SoundEvent(SoundEventType.TRADE, trade.getContract().getProduct());
        SoundType soundType = this.getSound(soundEvent);
        this.playSoundIfEnabled(soundType);
    }

    @Subscribe
    public void handleEntityLoadingStarted(EntityLoadingStartedEvent<?> entityLoadingStartedEvent) {
        if (entityLoadingStartedEvent.getEntityClass().equals(FullTrade.class)) {
            this.currentLoadingProcesses.incrementAndGet();
        }
    }

    @Subscribe
    public void handleEntityLoadingFinished(EntityLoadingFinishedEvent<?> entityLoadingFinishedEvent) {
        if (entityLoadingFinishedEvent.getEntityClass().equals(FullTrade.class)) {
            this.serverTimeAtStartOfDay = this.timeService.getServerTime().withTimeAtStartOfDay();
            this.currentLoadingProcesses.decrementAndGet();
        }
    }

    @Subscribe
    public void handleFailedOrderSubmissionEvent(FailedOrderSubmissionEvent event) {
        SoundType soundType = this.getSound(new SoundEvent(SoundEventType.FAILED_ORDER_ENTRY, event.getType()));
        this.playSoundIfEnabled(soundType);
    }

    @Subscribe
    public void handleUrgentMessageEvent(UrgentMessageEvent urgentMessageEvent) {
        SoundType soundType = this.getSound(new SoundEvent(SoundEventType.URGENT_MESSAGE, SoundEventType.URGENT_MESSAGE_CLASSIFIER));
        this.playSoundIfEnabled(soundType);
    }

    @Subscribe
    public void handleRecallTradeMessageEvent(TradeRecallRequestedMessageEvent recallTradeMessageEvent) {
        SoundType soundType = this.getSound(new SoundEvent(SoundEventType.TRADE_RECALL_REQUESTED, SoundEventType.TRADE_RECALL_REQUEST_MESSAGE_CLASSIFIER));
        this.playSoundIfEnabled(soundType);
    }

    private void playSoundIfEnabled(SoundType soundType) {
        if (this.shouldBePlayed(soundType)) {
            this.play(this.getAudioClipFromCache(soundType));
        }
    }

    private boolean shouldBePlayed(SoundType soundType) {
        return soundType != SoundType.OFF && this.currentLoadingProcesses.get() == 0;
    }

    private void initSoundsCache() {
        try (InputStream soundPropertiesStream = SoundServiceImpl.class.getResourceAsStream(SOUNDS_PROPERTIES_PATH);){
            Properties soundProperties = new Properties();
            soundProperties.load(soundPropertiesStream);
            soundProperties.stringPropertyNames().forEach(name -> this.loadSound((String)name, soundProperties.getProperty((String)name)));
            this.currentLoadingProcesses.decrementAndGet();
            LOG.info("Sound cache initialized (size: {})", (Object)this.soundsCache.size());
        }
        catch (IOException e) {
            LOG.error("Error while initializing the sounds cache", e);
        }
    }

    private void loadSound(String name, String soundFileName) {
        URL soundUrl = SoundServiceImpl.class.getResource(SOUNDS_PATH + soundFileName.trim());
        SoundType soundType = SoundType.valueOf(name.toUpperCase());
        if (soundUrl != null) {
            this.soundsCache.put(soundType, new AudioClip(soundUrl.toExternalForm()));
        } else {
            LOG.error("Sound file {} not loaded", (Object)soundFileName);
        }
    }

    @Override
    public void playSound(SoundType soundType) {
        this.play(this.getAudioClipFromCache(soundType));
    }

    protected void play(Optional<AudioClip> audioClip) {
        audioClip.ifPresent(AudioClip::play);
    }

    @Override
    public SoundType getSound(SoundEvent soundEvent) {
        return this.settingsService.loadSettings(this.getSoundSettingsForEvent(soundEvent));
    }

    protected Optional<AudioClip> getAudioClipFromCache(SoundType soundType) {
        AudioClip audioClip = this.soundsCache.get((Object)soundType);
        if (audioClip == null) {
            LOG.error("Audioclip {} not found in cache", (Object)soundType);
        }
        return Optional.ofNullable(audioClip);
    }

    @Override
    public void registerSound(SoundEvent soundEvent, SoundType soundType) {
        this.settingsService.storeSettings(this.getSoundSettingsForEvent(soundEvent), soundType);
    }

    private SettingsService.Settings<SoundType> getSoundSettingsForEvent(SoundEvent soundEvent) {
        switch (soundEvent.getSoundEventType()) {
            case FAILED_ORDER_ENTRY: {
                return this.orderSoundSettings((FailedOrderSubmissionEvent.Type)soundEvent.getClassifier());
            }
            case TRADE: {
                return this.tradeSoundSettings((Product)soundEvent.getClassifier());
            }
            case URGENT_MESSAGE: {
                return this.urgentMessageSettings();
            }
            case TRADE_RECALL_REQUESTED: {
                return this.tradeRecallMessageSettings();
            }
        }
        throw new IllegalArgumentException("Unsupported sound event type.");
    }

    private SettingsService.Settings<SoundType> tradeSoundSettings(Product product) {
        return new SettingsService.Settings<SoundType>(SoundService.class.getName() + "$" + product.getExchange().getId() + "$" + String.valueOf((Object)SoundEventType.TRADE) + "$" + (String)product.getId(), DEFAULT_SOUND);
    }

    private SettingsService.Settings<SoundType> orderSoundSettings(FailedOrderSubmissionEvent.Type type) {
        return new SettingsService.Settings<SoundType>(SoundService.class.getName() + "$" + String.valueOf((Object)SoundEventType.FAILED_ORDER_ENTRY) + "$" + String.valueOf(type), DEFAULT_SOUND);
    }

    private SettingsService.Settings<SoundType> urgentMessageSettings() {
        return new SettingsService.Settings<SoundType>(SoundService.class.getName() + "$" + String.valueOf((Object)SoundEventType.URGENT_MESSAGE), DEFAULT_SOUND);
    }

    private SettingsService.Settings<SoundType> tradeRecallMessageSettings() {
        return new SettingsService.Settings<SoundType>(SoundService.class.getName() + "$" + String.valueOf((Object)SoundEventType.TRADE_RECALL_REQUESTED), DEFAULT_SOUND);
    }
}

