/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service.style;

import com.deutscheboerse.comxerv.comtrader.core.util.DisplayName;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import javafx.scene.Scene;
import javafx.scene.text.Font;

public interface FontService {
    public static final FontSize DEFAULT_FONT_SIZE = FontSize.NORMAL;
    public static final FontFamily DEFAULT_FONT_FAMILY = FontFamily.SANS_SERIF;
    public static final VerticalBorder DEFAULT_VERTICAL_BORDER = VerticalBorder.THIN;
    public static final HorizontalBorder DEFAULT_HORIZONTAL_BORDER = HorizontalBorder.NONE;
    public static final CellPadding DEFAULT_CELL_PADDING = CellPadding.NONE;
    public static final PanelDivider DEFAULT_PANEL_DEVIDER = PanelDivider.THIN;

    public FontSize getFontSize();

    public void setFontSize(FontSize var1);

    public FontFamily getFontFamily();

    public void setFontFamily(FontFamily var1);

    public CellPadding getCellPadding();

    public void setCellPadding(CellPadding var1);

    public VerticalBorder getVerticalBorder();

    public void setVerticalBorder(VerticalBorder var1);

    public HorizontalBorder getHorizontalBorder();

    public void setHorizontalBorder(HorizontalBorder var1);

    public PanelDivider getPanelDivider();

    public void setPanelDivider(PanelDivider var1);

    public void registerSceneForFontSwitching(Scene var1);

    public static enum FontSize implements DisplayName
    {
        TINY(50, "fontSize_tiny"),
        SMALL(75, "fontSize_small"),
        NORMAL(100, "fontSize_normal"),
        BIG(125, "fontSize_big"),
        HUGE(150, "fontSize_huge");

        private final double fontSize;
        private final String labelKey;
        private final int percent;

        private FontSize(int percent, String labelKey) {
            this.labelKey = labelKey;
            this.fontSize = (double)percent * 0.01 * Font.getDefault().getSize();
            this.percent = percent;
        }

        public double getFontSize() {
            return this.fontSize;
        }

        @Override
        public String getDisplayName() {
            return Util.getLabel(this.labelKey);
        }

        public String getMultiplierStyleClass() {
            return "fontSize_" + this.percent;
        }
    }

    public static enum FontFamily implements DisplayName
    {
        SERIF("serif", "fontFamily_serif"),
        SANS_SERIF("sans-serif", "fontFamily_sansserif"),
        MONOSPACE("monospace", "fontFamily_monospace");

        private final String cssName;
        private final String labelKey;

        private FontFamily(String cssName, String labelKey) {
            this.cssName = cssName;
            this.labelKey = labelKey;
        }

        public String getCssName() {
            return this.cssName;
        }

        @Override
        public String getDisplayName() {
            return Util.getLabel(this.labelKey);
        }
    }

    public static enum VerticalBorder implements DisplayName
    {
        NONE("verticalBorder_none", "border_none"),
        THIN("verticalBorder_thin", "border_thin"),
        THICK("verticalBorder_thick", "border_thick");

        private final String styleClass;
        private final String labelKey;

        private VerticalBorder(String styleClass, String labelKey) {
            this.styleClass = styleClass;
            this.labelKey = labelKey;
        }

        public String getStyleClass() {
            return this.styleClass;
        }

        @Override
        public String getDisplayName() {
            return Util.getLabel(this.labelKey);
        }
    }

    public static enum HorizontalBorder implements DisplayName
    {
        NONE("horizontalBorder_none", "border_none"),
        THIN("horizontalBorder_thin", "border_thin"),
        THICK("horizontalBorder_thick", "border_thick");

        private final String styleClass;
        private final String labelKey;

        private HorizontalBorder(String styleClass, String labelKey) {
            this.styleClass = styleClass;
            this.labelKey = labelKey;
        }

        public String getStyleClass() {
            return this.styleClass;
        }

        @Override
        public String getDisplayName() {
            return Util.getLabel(this.labelKey);
        }
    }

    public static enum CellPadding implements DisplayName
    {
        NONE("cellPadding_none", "cellPadding_none"),
        SMALL("cellPadding_small", "cellPadding_small"),
        LARGE("cellPadding_large", "cellPadding_large");

        private final String styleClass;
        private final String labelKey;

        private CellPadding(String styleClass, String labelKey) {
            this.styleClass = styleClass;
            this.labelKey = labelKey;
        }

        public String getStyleClass() {
            return this.styleClass;
        }

        @Override
        public String getDisplayName() {
            return Util.getLabel(this.labelKey);
        }
    }

    public static enum PanelDivider implements DisplayName
    {
        NONE("panelDivider_none", "border_none"),
        THIN("panelDivider_thin", "border_thin"),
        THICK("panelDivider_thick", "border_thick");

        private final String styleClass;
        private final String labelKey;

        private PanelDivider(String styleClass, String labelKey) {
            this.styleClass = styleClass;
            this.labelKey = labelKey;
        }

        public String getStyleClass() {
            return this.styleClass;
        }

        @Override
        public String getDisplayName() {
            return Util.getLabel(this.labelKey);
        }
    }
}

