/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.util;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.domain.query.ContractQueries;
import com.deutscheboerse.comxerv.comtrader.domain.query.DeliveryAreaQueries;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.jfx.components.layout.PanelInClipBoard;
import com.deutscheboerse.comxerv.comtrader.jfx.util.SerializedOrder;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.WstxDriver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.Dragboard;

@Singleton
public class DragAndDropService {
    private final XStream xStream = new XStream(new WstxDriver());
    private static final DataFormat DATE_FORMAT__COMPONENT = new DataFormat("com.deutscheboerse.comxerv.comtrader.dateFormat.component");
    private static final DataFormat DATE_FORMAT__COMPONENT_CLASS_NAME = new DataFormat("com.deutscheboerse.comxerv.comtrader.dateFormat.componentClassName");
    private static final DataFormat DATE_FORMAT__ORDER_LIST = new DataFormat("com.deutscheboerse.comxerv.comtrader.dateFormat.orderlist");
    private static final DataFormat DATE_FORMAT__BASIC_ORDERBOOK_ENTRY_LIST = new DataFormat("com.deutscheboerse.comxerv.comtrader.basicOrderbookEntryList");
    private static final DataFormat DATE_FORMAT__CONTRACT_LIST = new DataFormat("com.deutscheboerse.comxerv.comtrader.dateFormat.contractList");
    private static final DataFormat DATA_FORMAT__PRODUCT_LIST = new DataFormat("com.deutscheboerse.comxerv.comtrader.dateFormat.productList");
    private final SmallFastDataModel<Long, Contract> contractDataModel;
    private final SmallFastDataModel<Long, Order> orderDataModel;
    private final SmallFastDataModel<String, Product> productDataModel;
    private final DeliveryAreaQueries deliveryAreaQueries;
    private final ContractQueries contractQueries;
    private final SmallFastDataModel<String, BalancingGroup> balancingGroupDataModel;

    @Inject
    public DragAndDropService(ApplicationContext context) {
        this.contractDataModel = context.getSmallDataModel(Contract.class);
        this.orderDataModel = context.getSmallDataModel(Order.class);
        this.productDataModel = context.getSmallDataModel(Product.class);
        this.deliveryAreaQueries = context.getService(DeliveryAreaQueries.class);
        this.balancingGroupDataModel = context.getSmallDataModel(BalancingGroup.class);
        this.contractQueries = context.getService(ContractQueries.class);
        this.xStream.allowTypes(new String[]{"com.deutscheboerse.comxerv.comtrader.jfx.util.SerializedOrder", "org.joda.time.DateTimeZone$Stub"});
    }

    public void setComponentClassName(Dragboard dragboard, String componentClassName) {
        ClipboardContent content = new ClipboardContent();
        content.put(DATE_FORMAT__COMPONENT_CLASS_NAME, componentClassName);
        dragboard.setContent(content);
    }

    public boolean hasComponentClassName(Dragboard dragboard) {
        return dragboard.hasContent(DATE_FORMAT__COMPONENT_CLASS_NAME);
    }

    public String getComponentClassName(Dragboard dragboard) {
        return (String)dragboard.getContent(DATE_FORMAT__COMPONENT_CLASS_NAME);
    }

    public void setComponent(Dragboard dragboard, PanelInClipBoard panelInClipBoard) {
        ClipboardContent content = new ClipboardContent();
        content.put(DATE_FORMAT__COMPONENT, panelInClipBoard);
        dragboard.setContent(content);
    }

    public boolean hasComponent(Dragboard dragboard) {
        return dragboard.hasContent(DATE_FORMAT__COMPONENT);
    }

    public PanelInClipBoard getComponent(Dragboard dragboard) {
        return (PanelInClipBoard)dragboard.getContent(DATE_FORMAT__COMPONENT);
    }

    public boolean hasComponentOrComponentClassName(Dragboard dragboard) {
        return this.hasComponent(dragboard) || this.hasComponentClassName(dragboard);
    }

    public boolean hasOrderList(Dragboard dragboard) {
        return dragboard.hasContent(DATE_FORMAT__ORDER_LIST);
    }

    public void setOrderList(Dragboard dragboard, List<Order> orders) {
        ClipboardContent content = new ClipboardContent();
        content.put(DATE_FORMAT__ORDER_LIST, this.serializeOrderList(orders));
        dragboard.setContent(content);
    }

    private String serializeOrderList(List<Order> orders) {
        StringBuilder sb = new StringBuilder();
        for (Order order : orders) {
            sb.append(order.getExchange().getId()).append("/").append(order.getId()).append("\n");
        }
        return sb.toString();
    }

    public List<Order> getOrderList(Dragboard dragboard) {
        String listStr = (String)dragboard.getContent(DATE_FORMAT__ORDER_LIST);
        return this.deserializeOrderList(listStr);
    }

    private List<Order> deserializeOrderList(String listStr) {
        String[] lines;
        if (listStr == null) {
            return null;
        }
        ArrayList<Order> orders = new ArrayList<Order>();
        for (String line : lines = listStr.split("\n")) {
            String[] idParts = line.split("/");
            Order order = (Order)this.orderDataModel.findById(Long.valueOf(idParts[1]));
            if (order == null) continue;
            orders.add(order);
        }
        return orders;
    }

    public void setOrderbookEntryList(Dragboard dragboard, List<Order> entries2) {
        ClipboardContent content = new ClipboardContent();
        ArrayList<SerializedOrder> serializedOrderList = new ArrayList<SerializedOrder>(entries2.size());
        for (Order order : entries2) {
            serializedOrderList.add(new SerializedOrder(order));
        }
        content.put(DATE_FORMAT__BASIC_ORDERBOOK_ENTRY_LIST, this.xStream.toXML(serializedOrderList));
        dragboard.setContent(content);
    }

    public boolean hasBasicOrderbookEntryList(Dragboard dragboard) {
        return dragboard.hasContent(DATE_FORMAT__BASIC_ORDERBOOK_ENTRY_LIST);
    }

    public List<Order> getBasicOrderbookEntryList(Dragboard dragboard) {
        List listStr = (List)this.xStream.fromXML((String)dragboard.getContent(DATE_FORMAT__BASIC_ORDERBOOK_ENTRY_LIST));
        return listStr != null ? SerializedOrder.getOrders(listStr, this.balancingGroupDataModel, this.contractDataModel, this.deliveryAreaQueries) : null;
    }

    public boolean hasContractList(Dragboard dragboard) {
        return dragboard.hasContent(DATE_FORMAT__CONTRACT_LIST);
    }

    public void setContractList(Dragboard dragboard, List<Contract> contracts) {
        ClipboardContent content = new ClipboardContent();
        StringBuilder sb = new StringBuilder();
        this.serializeContractList(sb, contracts);
        content.put(DATE_FORMAT__CONTRACT_LIST, sb.toString());
        dragboard.setContent(content);
    }

    public void setContractListFromProducts(Dragboard dragboard, List<Product> products) {
        ClipboardContent content = new ClipboardContent();
        StringBuilder sb = new StringBuilder();
        this.serializeContractListFromProducts(sb, products);
        content.put(DATE_FORMAT__CONTRACT_LIST, sb.toString());
        dragboard.setContent(content);
    }

    public List<Contract> getContractList(Dragboard dragboard) {
        String listStr = (String)dragboard.getContent(DATE_FORMAT__CONTRACT_LIST);
        return this.deserializeContractList(listStr);
    }

    public void setProductList(Dragboard dragboard, List<Product> products) {
        ClipboardContent content = new ClipboardContent();
        StringBuilder sb = new StringBuilder();
        for (Product product : products) {
            sb.append((String)product.getId()).append("\n");
        }
        content.put(DATA_FORMAT__PRODUCT_LIST, sb.toString());
        dragboard.setContent(content);
    }

    public List<Product> getProductList(Dragboard dragboard) {
        Object dragboardContent = dragboard.getContent(DATA_FORMAT__PRODUCT_LIST);
        ArrayList<Product> products = new ArrayList<Product>();
        if (dragboardContent instanceof String) {
            Stream.of(((String)dragboardContent).split("\n")).map(this.productDataModel::findById).filter(Objects::nonNull).forEach(products::add);
        }
        return products;
    }

    public boolean hasProductList(Dragboard dragboard) {
        return dragboard.hasContent(DATA_FORMAT__PRODUCT_LIST);
    }

    private void serializeContractList(StringBuilder sb, List<Contract> contracts) {
        for (Contract contract : contracts) {
            sb.append(contract.getId()).append("\n");
        }
    }

    private void serializeContractListFromProducts(StringBuilder sb, List<Product> products) {
        ArrayList<Contract> contracts = new ArrayList<Contract>();
        for (Product product : products) {
            contracts.addAll(this.contractQueries.findByProduct(product).getAll().toList());
        }
        Collections.sort(contracts, new DeliveryStartComparator());
        this.serializeContractList(sb, contracts);
    }

    public List<Contract> deserializeContractList(String listStr) {
        String[] lines;
        if (listStr == null || listStr.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Contract> contracts = new ArrayList<Contract>();
        for (String line : lines = listStr.split("\n")) {
            Contract contract = (Contract)this.contractDataModel.findById(Long.parseLong(line));
            if (contract == null) continue;
            contracts.add(contract);
        }
        return contracts;
    }

    private static final class DeliveryStartComparator
    implements Comparator<Contract> {
        private DeliveryStartComparator() {
        }

        @Override
        public int compare(Contract contract1, Contract contract2) {
            int dlvryStartComparison = contract1.getDeliveryStart().compareTo(contract2.getDeliveryStart());
            if (dlvryStartComparison == 0) {
                return contract2.getDeliveryDuration().compareTo(contract1.getDeliveryDuration());
            }
            return dlvryStartComparison;
        }
    }
}

