/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.domain.query.ContractQueries;
import com.deutscheboerse.comxerv.comtrader.domain.query.ProductQueries;
import com.deutscheboerse.comxerv.comtrader.entities.BespokeContract;
import com.deutscheboerse.comxerv.comtrader.entities.BlockContract;
import com.deutscheboerse.comxerv.comtrader.entities.CompoundStatus;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractType;
import com.deutscheboerse.comxerv.comtrader.entities.type.ProductType;
import com.deutscheboerse.comxerv.comtrader.service.BlockContractService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Optional;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

@Singleton
public class BlockContractServiceImpl
implements BlockContractService {
    private final ContractQueries contractQueries;
    private final ProductQueries productQueries;

    @Inject
    public BlockContractServiceImpl(ApplicationContext appContext) {
        this.contractQueries = appContext.getService(ContractQueries.class);
        this.productQueries = appContext.getService(ProductQueries.class);
    }

    @Override
    public Optional<BlockContract> createBlockContract(Contract frontContract, Contract rearContract, Product blockProduct) {
        if (!this.isValidBlockContractSide(frontContract)) {
            return Optional.empty();
        }
        if (!this.isValidBlockContractSide(rearContract)) {
            return Optional.empty();
        }
        if (!this.isFrontAndRearContractAndBlockProductConsistent(frontContract, rearContract, blockProduct)) {
            return Optional.empty();
        }
        BlockContract blockContract = (BlockContract)this.contractQueries.findByProduct(blockProduct).addFilter(contract -> contract instanceof BlockContract).addFilter(contract -> {
            BlockContract existingContract = (BlockContract)contract;
            if (existingContract.getFrontContract() == null || existingContract.getFrontContract().getId() == null || existingContract.getRearContract() == null || existingContract.getRearContract().getId() == null) {
                return false;
            }
            return ((Long)existingContract.getFrontContract().getId()).equals(frontContract.getId()) && ((Long)existingContract.getRearContract().getId()).equals(rearContract.getId());
        }).getAny().orElseGet(() -> {
            BlockContract newBlockContract = new BlockContract(blockProduct, () -> this.contractQueries.findByProduct(frontContract.getProduct()).addFilter(contract -> !contract.getDeliveryStart().isBefore(frontContract.getDeliveryStart())).addFilter(contract -> !contract.getDeliveryEnd().isAfter(rearContract.getDeliveryEnd())).getAll());
            newBlockContract.setId(null);
            return newBlockContract;
        });
        if (blockContract.getId() == null) {
            CompoundStatus frontContractStatus = frontContract.getCompoundStatus();
            CompoundStatus rearContractStatus = rearContract.getCompoundStatus();
            blockContract.getCompoundStatus().setContractStatus(frontContractStatus.getContractStatus());
            blockContract.getCompoundStatus().setTradingPhase(frontContractStatus.getTradingPhase());
            for (DeliveryArea da : frontContractStatus.getDeliveryAreas()) {
                if (frontContractStatus.getActivePeriod(da) == null || rearContractStatus.getActivePeriod(da) == null) continue;
                DateTime start = frontContractStatus.getActivePeriod(da).getStart();
                DateTime end = rearContractStatus.getActivePeriod(da).getEnd();
                CompoundStatus.DeliveryAreaInfo daInfo = new CompoundStatus.DeliveryAreaInfo(frontContractStatus.getDeliveryAreaStatusOrContractStatus(da), frontContractStatus.getDeliveryAreaPhase(da), new Interval((ReadableInstant)start, (ReadableInstant)end));
                blockContract.getCompoundStatus().setDeliveryAreaInfo(da, daInfo);
            }
            blockContract.setDeliveryStart(frontContract.getDeliveryStart());
            blockContract.setDeliveryEnd(rearContract.getDeliveryEnd());
            blockContract.setExpiryPoint(frontContract.getExpiryPoint());
            blockContract.setName(frontContract.getName() + "-" + rearContract.getName());
        }
        return Optional.of(blockContract);
    }

    @Override
    public boolean isValidBlockContractSide(Contract contract) {
        return contract != null && !(contract instanceof BespokeContract) && contract.getType() == ContractType.REGULAR && this.isValidBlockProduct(contract.getProduct());
    }

    @Override
    public boolean isValidBlockProduct(Product product) {
        return product != null && (product.isBlockOrderProduct() || product.isBaseProduct() && this.familyContainsBlockProduct(product));
    }

    @Override
    public boolean isFrontAndRearContractAndBlockProductConsistent(Contract frontContract, Contract rearContract, Product blockProduct) {
        return this.isFrontAndRearContractConsistent(frontContract, rearContract) && (blockProduct.isBlockOrderProduct() && ((String)blockProduct.getId()).equals(frontContract.getProduct().getId()) || blockProduct.getProductType() == ProductType.USER_DEFINED_DELIVERY_PERIOD && blockProduct.getBaseProductId().equals(frontContract.getProduct().getId()));
    }

    @Override
    public boolean isFrontAndRearContractConsistent(Contract frontContract, Contract rearContract) {
        return frontContract.getProduct().equals(rearContract.getProduct()) && frontContract.getDeliveryStart().isBefore(rearContract.getDeliveryStart());
    }

    private boolean familyContainsBlockProduct(Product product) {
        return this.getBlockProduct(product) != null;
    }

    @Override
    public Product getBlockProduct(Product product) {
        if (product.getId() == null) {
            return null;
        }
        if (product.isBlockOrderProduct()) {
            return product;
        }
        return this.productQueries.findProductsByBaseProductId((String)product.getId()).getAll().filter(p -> p.getProductType() == ProductType.USER_DEFINED_DELIVERY_PERIOD).filter(p -> p.getProductState().isActive()).findFirst().orElse(null);
    }
}

