/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.entities.HubToHub;
import com.deutscheboerse.comxerv.comtrader.entities.Message;
import com.deutscheboerse.comxerv.comtrader.entities.PublicTradeConfirmation;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.monitoring.Monitor;
import com.deutscheboerse.comxerv.comtrader.service.event.LoadingFinishedEvent;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupServiceImpl {
    private static final int CLEANUP_INTERVAL_IN_MINUTES = 60;
    private final ApplicationContext appContext;
    private final Monitor monitor;
    private final boolean statsDEnabled;
    private static final Logger LOG = LoggerFactory.getLogger(CleanupServiceImpl.class);

    @Inject
    public CleanupServiceImpl(ApplicationContext appContext) {
        this.appContext = appContext;
        this.monitor = appContext.getService(Monitor.class);
        this.statsDEnabled = Boolean.getBoolean("statsd.enabled");
        ScheduledExecutorService executor = appContext.getService(ScheduledExecutorService.class, WorkerExecutor.class);
        LOG.info("Configuring old data cleanup to run every {} minutes", (Object)60);
        executor.scheduleAtFixedRate(this::cleanDataModels, 2L, 60L, TimeUnit.MINUTES);
        appContext.getService(EventBus.class).register(this);
    }

    @Subscribe
    public void initializeCleaningDataModels(LoadingFinishedEvent loadingFinished) {
        LOG.info("Executing initial cleanup after LoadingFinishedEvent was received.");
        this.cleanDataModels();
    }

    private void cleanDataModels() {
        FxUtil.runInFxThread(() -> {
            LOG.info("Running old data cleanup");
            this.logDataModelSizes();
            LocalDateTime startCleanup = LocalDateTime.now();
            this.appContext.getDataModel(Message.class).runCleanup();
            long messageCleanupDuration = Duration.between(startCleanup, LocalDateTime.now()).toMillis();
            LOG.info("Message cleanup duration: {}ms", (Object)messageCleanupDuration);
            this.monitor.cleanupDuration(messageCleanupDuration, Message.class.getName());
            LocalDateTime startFullTrade = LocalDateTime.now();
            this.appContext.getDataModel(FullTrade.class).runCleanup();
            long fullTradeCleanupDuration = Duration.between(startFullTrade, LocalDateTime.now()).toMillis();
            LOG.info("FullTrade cleanup duration: {}ms", (Object)fullTradeCleanupDuration);
            this.monitor.cleanupDuration(fullTradeCleanupDuration, FullTrade.class.getName());
            LocalDateTime startContract = LocalDateTime.now();
            this.appContext.getDataModel(Contract.class).runCleanup();
            long contractCleanupDuration = Duration.between(startContract, LocalDateTime.now()).toMillis();
            LOG.info("Contract cleanup duration: {}ms", (Object)contractCleanupDuration);
            this.monitor.cleanupDuration(contractCleanupDuration, Contract.class.getName());
            LocalDateTime startConfirmation = LocalDateTime.now();
            this.appContext.getDataModel(PublicTradeConfirmation.class).runCleanup();
            long publicTradeConfirmationCleanupDuration = Duration.between(startConfirmation, LocalDateTime.now()).toMillis();
            LOG.info("Confirmation cleanup duration: {}ms", (Object)publicTradeConfirmationCleanupDuration);
            this.monitor.cleanupDuration(publicTradeConfirmationCleanupDuration, PublicTradeConfirmation.class.getName());
            LocalDateTime startOrderBook = LocalDateTime.now();
            this.appContext.getDataModel(Orderbook.class).runCleanup();
            long orderBookCleanupDuration = Duration.between(startOrderBook, LocalDateTime.now()).toMillis();
            LOG.info("OrderBook cleanup duration: {}ms", (Object)orderBookCleanupDuration);
            this.monitor.cleanupDuration(orderBookCleanupDuration, Orderbook.class.getName());
            LocalDateTime startHubToHub = LocalDateTime.now();
            this.appContext.getDataModel(HubToHub.class).runCleanup();
            long hubToHubCleanupDuration = Duration.between(startHubToHub, LocalDateTime.now()).toMillis();
            LOG.info("HubToHub cleanup duration: {}ms", (Object)hubToHubCleanupDuration);
            this.monitor.cleanupDuration(hubToHubCleanupDuration, HubToHub.class.getName());
            LOG.info("Old data cleanup total duration: {}ms", (Object)Duration.between(startCleanup, LocalDateTime.now()).toMillis());
        });
    }

    private void logDataModelSizes() {
        if (this.statsDEnabled) {
            this.monitor.entitySize(this.appContext.getDataModel(Message.class).size(), Message.class.getName());
            this.monitor.entitySize(this.appContext.getDataModel(FullTrade.class).size(), FullTrade.class.getName());
            this.monitor.entitySize(this.appContext.getDataModel(Contract.class).size(), Contract.class.getName());
            this.monitor.entitySize(this.appContext.getDataModel(PublicTradeConfirmation.class).size(), PublicTradeConfirmation.class.getName());
            this.monitor.entitySize(this.appContext.getDataModel(Orderbook.class).size(), Orderbook.class.getName());
            this.monitor.entitySize(this.appContext.getDataModel(HubToHub.class).size(), HubToHub.class.getName());
        }
    }
}

