/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service;

import com.deutscheboerse.comxerv.comtrader.app.login.MasterLoginWindow;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.type.JodaDateFormatType;
import com.deutscheboerse.comxerv.comtrader.entities.type.NumberStyleType;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.service.LocalService;
import com.deutscheboerse.comxerv.comtrader.service.csv.FormattedBigDecimal;
import com.deutscheboerse.comxerv.comtrader.service.event.SaveConfigurationEvent;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileManager;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsLoadedEvent;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LocalServiceImpl
implements LocalService {
    private static final Logger LOG = LoggerFactory.getLogger(LocalServiceImpl.class);
    protected static final SettingsService.Settings<String> SELECTED_LANGUAGE_SETTINGS = new SettingsService.Settings<String>("locale-lang", "en");
    protected static final SettingsService.Settings<String> CUSTOM_BUNDLE_SETTINGS = new SettingsService.Settings<String>("custom-bundle", "");
    protected static final SettingsService.Settings<NumberStyleType> SELECTED_NUMBER_STYLE_SETTINGS = new SettingsService.Settings<NumberStyleType>("number-style", DEFAULT_NUMBER_STYLE);
    protected static final SettingsService.Settings<Boolean> ENABLED_GROUPING_SEPARATOR_SETTINGS = new SettingsService.Settings<Boolean>("enabled-grouping-separator", false);
    protected static final SettingsService.Settings<JodaDateFormatType> SELECTED_JODA_DATE_FORMAT_SETTINGS = new SettingsService.Settings<JodaDateFormatType>("joda-date-format", DEFAULT_JODA_TIME_FORMAT);
    protected static final SettingsService.Settings<JodaDateFormatType> SELECTED_JODA_DATE_TIMEZONE_FORMAT_SETTINGS = new SettingsService.Settings<JodaDateFormatType>("joda-date-format", DEFAULT_JODA_TIME_WITH_TIMEZONE_FORMAT);
    protected static final Locale CUSTOM_LOCALE = new Locale("Custom");
    private final ProfileManager profileManager;
    private final SettingsService settingsService;
    private final Supplier<MasterLoginWindow> masterLoginWindow;
    private final ApplicationConfigurationService configurationService;
    private final ExecutorService executorService;
    private ResourceBundle customBundle;

    @Inject
    public LocalServiceImpl(ApplicationContext appContext) {
        this.profileManager = appContext.getService(ProfileManager.class);
        this.settingsService = appContext.getService(SettingsService.class);
        this.masterLoginWindow = () -> appContext.getService(MasterLoginWindow.class);
        this.configurationService = appContext.getService(ApplicationConfigurationService.class);
        this.executorService = appContext.getService(ExecutorService.class, WorkerExecutor.class);
        appContext.getService(EventBus.class).register(this);
    }

    @Subscribe
    public void handleSettingsLoaded(SettingsLoadedEvent event) {
        String customBundleContent = this.settingsService.loadSettings(CUSTOM_BUNDLE_SETTINGS);
        if (customBundleContent != null && !customBundleContent.isEmpty()) {
            this.loadCustomBundle(customBundleContent);
        } else {
            this.customBundle = null;
        }
        this.applyLocale(this.getConfiguredLocale());
        this.applyGroupingSeparator(this.isGroupingSeparatorEnabled());
        this.applyUpdateNumberStyle(this.getNumberStyleType());
    }

    @Subscribe
    public void handleSaveConfiguration(SaveConfigurationEvent event) {
        this.profileManager.getCurrentProfile().setSetting(SELECTED_LANGUAGE_SETTINGS.getKey(), Util.getCurrentOrDefaultLocale().toString());
    }

    @Override
    public Locale getConfiguredLocale() {
        String localeLanguage = this.settingsService.loadSettings(SELECTED_LANGUAGE_SETTINGS);
        return Optional.of(localeLanguage).filter(lang -> !lang.isEmpty()).map(Locale::new).filter(this.getAvailableLanguages()::contains).orElse(Locale.getDefault());
    }

    @Override
    public void storeConfiguredLocale(Locale locale) {
        this.settingsService.storeSettings(SELECTED_LANGUAGE_SETTINGS, locale.getLanguage());
        this.applyLocale(locale);
    }

    @Override
    public void storeNumberStyleType(NumberStyleType numberStyleType) {
        this.settingsService.storeSettings(SELECTED_NUMBER_STYLE_SETTINGS, numberStyleType);
        this.applyUpdateNumberStyle(numberStyleType);
    }

    @Override
    public NumberStyleType getNumberStyleType() {
        return this.settingsService.loadSettings(SELECTED_NUMBER_STYLE_SETTINGS);
    }

    @Override
    public void storeGroupingSeparatorEnabled(boolean groupingSeparatorEnabled) {
        this.settingsService.storeSettings(ENABLED_GROUPING_SEPARATOR_SETTINGS, groupingSeparatorEnabled);
        this.applyGroupingSeparator(groupingSeparatorEnabled);
    }

    @Override
    public boolean isGroupingSeparatorEnabled() {
        return this.settingsService.loadSettings(ENABLED_GROUPING_SEPARATOR_SETTINGS);
    }

    @Override
    public void storeJodaDateFormat(JodaDateFormatType dateFormatType) {
        this.settingsService.storeSettings(SELECTED_JODA_DATE_FORMAT_SETTINGS, dateFormatType);
    }

    @Override
    public JodaDateFormatType getJodaDateFormat() {
        return this.settingsService.loadSettings(SELECTED_JODA_DATE_FORMAT_SETTINGS);
    }

    @Override
    public JodaDateFormatType getJodaDateWithTimezoneFormat() {
        return this.settingsService.loadSettings(SELECTED_JODA_DATE_TIMEZONE_FORMAT_SETTINGS);
    }

    @Override
    public String formatDateTime(DateTime date) {
        return date == null ? "" : this.getJodaDateFormat().printSimpleDateFormat(date);
    }

    @Override
    public String formatDateTime(DateTime date, String timeZone) {
        return date == null ? "" : this.getJodaDateWithTimezoneFormat().printSimpleDateFormatWithTimezone(date, DateTimeZone.forID(timeZone));
    }

    @Override
    public String formatDate(DateTime date) {
        return date == null ? "" : this.getJodaDateFormat().printJustDateDateFormat(date);
    }

    @Override
    public String formatData(LocalDate localDate) {
        return this.formatDate(localDate.toDateTimeAtStartOfDay());
    }

    @Override
    public Object format(BigDecimal bigDecimal) {
        return new FormattedBigDecimal(bigDecimal);
    }

    @Override
    public String formatLongDisplayValue(LongDisplayValue longDisplayValue) {
        return this.getNumberStyleType().format(longDisplayValue.getDisplayValue(), this.isGroupingSeparatorEnabled());
    }

    private void applyUpdateNumberStyle(NumberStyleType numberStyleType) {
        Util.updateNumberStyle(numberStyleType);
    }

    private void applyGroupingSeparator(boolean enabled) {
        Util.updateGroupingSeparator(enabled);
    }

    private void applyLocale(Locale locale) {
        if (!Util.getCurrentOrDefaultLocale().equals(locale)) {
            Util.setLocale(locale);
            if (CUSTOM_LOCALE.equals(locale)) {
                Util.setBundle(this.customBundle);
            }
            this.masterLoginWindow.get().reloadLabels();
        }
    }

    @Override
    public Future<Locale> loadCustomBundle(File bundle) {
        return this.executorService.submit(() -> this.loadCustomBundleSync(bundle));
    }

    private Locale loadCustomBundleSync(File bundle) throws IOException {
        Locale locale;
        FileInputStream fileInputStream = new FileInputStream(bundle);
        try {
            String bundleContent = IOUtils.toString((InputStream)fileInputStream, StandardCharsets.UTF_8);
            this.loadCustomBundle(bundleContent);
            this.validateCustomBundle();
            this.settingsService.storeSettings(CUSTOM_BUNDLE_SETTINGS, bundleContent);
            this.storeConfiguredLocale(CUSTOM_LOCALE);
            locale = CUSTOM_LOCALE;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.error("Could not read custom locale", e);
                throw e;
            }
        }
        fileInputStream.close();
        return locale;
    }

    private void loadCustomBundle(String bundleContent) {
        try {
            this.customBundle = new PropertyResourceBundle(IOUtils.toInputStream(bundleContent, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            LOG.error("Could not parse custom bundle", e);
        }
    }

    private void validateCustomBundle() {
        for (String commonLabel : Util.getLabels().keySet()) {
            if (this.customBundle.containsKey(commonLabel)) continue;
            String errorText = "Could not find '" + commonLabel + "' in custom locale.";
            LOG.error(errorText);
            throw new MissingResourceException(errorText, "custom locale", commonLabel);
        }
    }

    @Override
    public Collection<Locale> getAvailableLanguages() {
        List<Locale> availableLanguages = Stream.of(this.configurationService.getApplicationProperty("availableLanguages", "").split(",")).map(Locale::new).collect(Collectors.toList());
        if (this.customBundle != null) {
            availableLanguages.add(CUSTOM_LOCALE);
        }
        return availableLanguages;
    }
}

