/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv.order;

import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportException;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.StringColumn;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.ValidationMessage;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.Arrays;
import java.util.Collection;

public class OrderAotColumn
extends StringColumn<Order>
implements ImportColumn<String, Order> {
    private static final boolean DEFAULT_AOT_VALUE = Boolean.FALSE;
    private static final String LABEL_YES = Util.getLabel("commons_yes");
    private static final String LABEL_NO = Util.getLabel("commons_no");

    public OrderAotColumn(String header) {
        super(header);
    }

    @Override
    public void applyValue(String value, Order importedObject) throws ImportException {
        if (value == null) {
            importedObject.setAot(DEFAULT_AOT_VALUE);
        } else if (value.equalsIgnoreCase(LABEL_YES)) {
            importedObject.setAot(Boolean.TRUE);
        } else if (value.equalsIgnoreCase(LABEL_NO)) {
            importedObject.setAot(Boolean.FALSE);
        } else {
            throw new ImportException("Invalid Aot", Util.getLabel("importException_invalidAot"));
        }
    }

    @Override
    public String parseValue(String data) throws ImportException {
        if (data == null || data.equalsIgnoreCase(LABEL_YES) || data.equalsIgnoreCase(LABEL_NO)) {
            return data;
        }
        throw new ImportException("Invalid Aot", Util.getLabel("importException_invalidAot"));
    }

    @Override
    public String getValue(Order objectToExport) {
        return Boolean.TRUE.equals(objectToExport.getAot()) ? LABEL_YES : LABEL_NO;
    }

    @Override
    public Collection<String> getErrorCodesKeys() {
        return Arrays.asList(ValidationMessage.ORDER_VALIDATION_ERROR_AOT_NOT_ENABLED.getMessageKey(), ValidationMessage.ORDER_VALIDATION_ERROR_AOT_EXEC_RES.getMessageKey());
    }
}

