/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv.trade;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.HalfTrade;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.service.LocalService;
import com.deutscheboerse.comxerv.comtrader.service.csv.FormattedBigDecimal;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.Column;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ExportColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.trade.TraceQuantityColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.trade.TradeCurrencyColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.trade.TradeDirectionColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.trade.TradeLocationColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.trade.TradeLongContractNameColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.trade.TradeOwnOrderAccountColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.trade.TradeOwnOrderAggressorIndicatorTypeColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.trade.TradeOwnOrderBalancingGroupNameColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.trade.TradeOwnOrderDeliveryAreaIdColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.trade.TradeOwnOrderDeliveryAreaNameColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.trade.TradeOwnOrderIdColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.trade.TradeOwnOrderTextColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.trade.TradeOwnOrderTraderIdColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.trade.TradePriceColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.trade.TradeProductIdColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.trade.TradeSelfTradeColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.trade.TradeTimestampColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.trade.TradeTradeIdColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.trade.TradeTradeStateLongNameColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.trade.TradeTradeTypeColumn;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ContinuousTradePrepareExportService {
    private static final Logger LOG = LoggerFactory.getLogger(ContinuousTradePrepareExportService.class);
    private final ApplicationContext appContext;
    private ImmutableList<ExportColumn<?, HalfTrade>> supportedColumns;

    @Inject
    public ContinuousTradePrepareExportService(ApplicationContext appContext) {
        this.appContext = appContext;
    }

    public List<String> getColumnNames() {
        return this.getSupportedColumns().stream().map(Column::getHeader).toList();
    }

    public List<Object> getExportedDataItem(HalfTrade item) {
        ArrayList<Object> values2 = new ArrayList<Object>(this.getSupportedColumns().size());
        for (ExportColumn exportColumn : this.getSupportedColumns()) {
            Object value = exportColumn.getValue(item);
            if (value == null) {
                values2.add("");
                continue;
            }
            if (this.isNumericColumn(exportColumn)) {
                if (this.isColumnExcludedFromNumericFormatting(exportColumn)) {
                    values2.add(this.numericToBigDecinal(value));
                    continue;
                }
                FormattedBigDecimal formattedBigDecimal = new FormattedBigDecimal(this.numericToBigDecinal(value));
                values2.add(formattedBigDecimal);
                String input = exportColumn.getStringValue(value);
                if (input.equals(formattedBigDecimal.toString())) continue;
                LOG.error("{} -> {}", (Object)input, (Object)formattedBigDecimal);
                continue;
            }
            values2.add(exportColumn.getStringValue(value));
        }
        return values2;
    }

    private ImmutableList<ExportColumn<?, HalfTrade>> getSupportedColumns() {
        if (this.supportedColumns == null) {
            this.supportedColumns = this.createSupportedColumns();
        }
        return this.supportedColumns;
    }

    private ImmutableList<ExportColumn<?, HalfTrade>> createSupportedColumns() {
        ActiveExchange activeExchange = this.appContext.getService(ActiveExchange.class);
        MutableList<ExportColumn> columns = Lists.mutable.of(new TradeOwnOrderTraderIdColumn("continuousTradeExport_header_trader"), new TradeOwnOrderDeliveryAreaNameColumn("continuousTradeExport_header_tso"), new TradeOwnOrderDeliveryAreaIdColumn("continuousTradeExport_header_eic"), new TradeDirectionColumn("continuousTradeExport_header_side"), new TradeProductIdColumn("continuousTradeExport_header_product"), new TradeLongContractNameColumn("continuousTradeExport_header_contract"), new TraceQuantityColumn("continuousTradeExport_header_quantity"), new TradePriceColumn("continuousTradeExport_header_price"), new TradeCurrencyColumn("continuousTradeExport_header_currency"), new TradeOwnOrderAccountColumn("continuousTradeExport_header_account"), new TradeOwnOrderTextColumn("continuousTradeExport_header_text"), new TradeTradeStateLongNameColumn("continuousTradeExport_header_state"), new TradeOwnOrderIdColumn("continuousTradeExport_header_orderNumber"), new TradeTradeIdColumn("continuousTradeExport_header_tradeNumber"), new TradeTradeTypeColumn("continuousTradeExport_header_tradeType"), new TradeTimestampColumn("continuousTradeExport_header_timestamp", this.appContext.getService(LocalService.class), activeExchange), new TradeOwnOrderBalancingGroupNameColumn("continuousTradeExport_header_balancingGroup"), new TradeOwnOrderAggressorIndicatorTypeColumn("continuousTradeExport_header_aggrInd"), new TradeSelfTradeColumn("continuousTradeExport_header_selfTrade"));
        if (activeExchange.getActiveExchange().get() != null && activeExchange.getActiveExchange().get().getSystemInfo().supportsLocations()) {
            columns.add(new TradeLocationColumn("continuousTradeExport_header_location"));
        }
        return columns.toImmutable();
    }

    private boolean isNumericColumn(ExportColumn<?, HalfTrade> exportColumn) {
        return LongDisplayValue.class.equals(exportColumn.getValueClass()) || Long.class.equals(exportColumn.getValueClass());
    }

    private BigDecimal numericToBigDecinal(Object val) {
        if (val instanceof LongDisplayValue) {
            return ((LongDisplayValue)val).getDisplayValue();
        }
        if (val instanceof Long) {
            return new BigDecimal((Long)val);
        }
        throw new IllegalArgumentException("Unsupported export numeric column value " + String.valueOf(val.getClass()));
    }

    private boolean isColumnExcludedFromNumericFormatting(ExportColumn<?, HalfTrade> column) {
        return column instanceof TradeOwnOrderIdColumn || column instanceof TradeTradeIdColumn;
    }
}

