/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.listener;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.AbstractDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.domain.query.OrderbookQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.service.OwnQuantityLookupService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.List;

@Singleton
public class ContractToOrderbookDataModelListener
extends AbstractDataModelListener<Contract> {
    private final DataModel<String, Orderbook> orderbookDataModel;
    private final ApplicationContext appContext;
    private final OrderbookQueries orderbookQueries;
    private final OwnQuantityLookupService ownQuantityLookupService;

    @Inject
    public ContractToOrderbookDataModelListener(ApplicationContext applicationContext) {
        this.appContext = applicationContext;
        this.orderbookDataModel = applicationContext.getDataModel(Orderbook.class);
        this.orderbookQueries = this.appContext.getService(OrderbookQueries.class);
        this.ownQuantityLookupService = this.appContext.getService(OwnQuantityLookupService.class);
        applicationContext.getSmallDataModel(Contract.class).registerListener(this);
    }

    @Override
    public DataModelListener.NotificationResult notifyUpdate(Contract object) {
        this.createOrderbooksIfNotExistsYet(object);
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyAdd(Contract object) {
        this.createOrderbooksIfNotExistsYet(object);
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyRemove(Contract object) {
        this.orderbookQueries.findByContract(object).forEach(this.orderbookDataModel::remove);
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyRemoveAll() {
        this.orderbookDataModel.removeAll();
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyRemoveAll(Collection<Contract> objects) {
        List orderbooksToRemove = objects.stream().flatMap(contract -> this.orderbookQueries.findByContract((Contract)contract).stream()).toList();
        this.orderbookDataModel.removeAll(orderbooksToRemove);
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    private void createOrderbooksIfNotExistsYet(Contract contract) {
        if (!contract.getCompoundStatus().getContractStatus().isInactive()) {
            this.orderbookDataModel.handleBroadcastEntities(contract.getCompoundStatus().getDeliveryAreas().stream().filter(da -> !this.orderbookQueries.findByContractIdAndDeliveryAreaId((Long)contract.getId(), (String)da.getId()).isPresent()).map(deliveryArea -> this.createOrderbook(contract, (DeliveryArea)deliveryArea)).toList());
        }
    }

    private Orderbook createOrderbook(Contract contract, DeliveryArea deliveryArea) {
        Orderbook orderbook = new Orderbook(contract, deliveryArea, this.ownQuantityLookupService);
        orderbook.setRevisionNumber(-1L);
        orderbook.setId((String)deliveryArea.getId() + "|" + String.valueOf(contract.getId()));
        return orderbook;
    }
}

