/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.orderentry.action;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.CommonOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ExtendedOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractType;
import com.deutscheboerse.comxerv.comtrader.entities.type.ExecutionRestriction;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderStatus;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.entities.type.ProductExecutionRestriction;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.action.OrderActionsService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.preference.OrderPreferencesService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Optional;

@Singleton
public class OrderActionsServiceImpl
implements OrderActionsService {
    private final DataModel<Long, Order> orderDataModel;
    private final DataModel<String, BalancingGroup> balancingGroupDataModel;
    private final OrderPreferencesService orderPreferencesService;
    private final UserService userService;
    private final DataModel<String, DeliveryArea> deliveryAreaDataModel;

    @Inject
    public OrderActionsServiceImpl(ApplicationContext appContext) {
        this.balancingGroupDataModel = appContext.getDataModel(BalancingGroup.class);
        this.orderPreferencesService = appContext.getService(OrderPreferencesService.class);
        this.orderDataModel = appContext.getDataModel(Order.class);
        this.userService = appContext.getService(UserService.class);
        this.deliveryAreaDataModel = appContext.getDataModel(DeliveryArea.class);
    }

    @Override
    public Optional<Order> getOriginalOrder(CommonOrderbookEntry entry) {
        if (entry instanceof ExtendedOrderbookEntry) {
            return Optional.ofNullable(this.orderDataModel.findById(((ExtendedOrderbookEntry)entry).getOrderId()));
        }
        return Optional.empty();
    }

    @Override
    public Order createOrderFromOrderbookEntry(CommonOrderbookEntry entry, OrderActionsService.PreparedOrderQuantitySelector quantitySelector) {
        Order newOrder = new Order();
        newOrder.setId(null);
        User user = this.userService.getCurrentUser();
        newOrder.setBalancingGroup(this.balancingGroupDataModel.findById(user.getDefaultBalancingGroup()));
        newOrder.setDirection(entry.getDirection());
        newOrder.setAccount(this.orderPreferencesService.getDefaultAccount());
        newOrder.setContract(entry.getOrderbook().getContract());
        DeliveryArea deliveryArea = this.deliveryAreaDataModel.findById(entry.getOrderbook().getDeliveryAreaId());
        newOrder.setDeliveryArea(deliveryArea);
        newOrder.setOrderType(OrderType.REGULAR);
        if (entry.getOrderbook().getContract().getType() == ContractType.UDB || entry.getOrderbook().getContract().getProduct().getExecutionRestriction() == ProductExecutionRestriction.ALL_OR_NOTHING) {
            newOrder.setExecutionRestriction(ExecutionRestriction.ALL_OR_NOTHING);
        } else {
            newOrder.setExecutionRestriction(ExecutionRestriction.NONE);
        }
        newOrder.setValidityRestriction(this.orderPreferencesService.getDefaultValidityRestriction());
        newOrder.setStatus(OrderStatus.ACTIVE);
        newOrder.setLimitPrice(entry.getPrice());
        if (quantitySelector == OrderActionsService.PreparedOrderQuantitySelector.FIRM) {
            newOrder.setRemainingQuantity(entry.getQuantity());
        } else if (quantitySelector == OrderActionsService.PreparedOrderQuantitySelector.TRADABLE) {
            newOrder.setRemainingQuantity(entry.getTradableQuantity());
        } else if (quantitySelector == OrderActionsService.PreparedOrderQuantitySelector.ACCUMULATED) {
            newOrder.setRemainingQuantity(entry.getAccQuantity());
        } else if (quantitySelector == OrderActionsService.PreparedOrderQuantitySelector.OWN_FIRM) {
            newOrder.setRemainingQuantity(entry.getOwnQuantity());
        }
        return newOrder;
    }
}

