/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.orderentry.basket;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.event.PreLogoutEvent;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.basket.Basket;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.basket.BasketService;
import com.deutscheboerse.comxerv.comtrader.service.user.OnBehalfService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import javafx.beans.property.ReadOnlyObjectProperty;

@Singleton
public class BasketServiceImpl
implements BasketService,
OnBehalfService.OnBehalfChangeVeto {
    private final Basket activeBasket;
    private final UserAlertService userAlertService;
    private final ReadOnlyObjectProperty<User> selectedOnBehalfUsers;

    @Inject
    public BasketServiceImpl(ApplicationContext applicationContext) {
        this.activeBasket = new Basket(applicationContext);
        this.userAlertService = applicationContext.getService(UserAlertService.class);
        OnBehalfService onBehalfService = applicationContext.getService(OnBehalfService.class);
        onBehalfService.registerOnBehalfVeto(this);
        this.selectedOnBehalfUsers = onBehalfService.onBehalfUserProperty();
        this.selectedOnBehalfUsers.addListener((observable2, oldValue, newValue) -> this.activeBasket.clear());
        applicationContext.getService(EventBus.class).register(this);
    }

    @Override
    public Basket getActiveBasket() {
        return this.activeBasket;
    }

    @Subscribe
    public void handlePreLogout(PreLogoutEvent preLogoutEvent) {
        this.activeBasket.removeAll();
    }

    @Override
    public boolean vetoOnBehalfChange(User currentUser) {
        return !this.userAlertService.showQuestionDialog(Util.getLabel("commons_ChangeOnBehalfUser"), Util.getLabel("basketContainsOnBehalfOrders", currentUser.getUserCode()), new UserAlertService.Flag[0]);
    }

    @Override
    public boolean vetoOnBehalfEnter() {
        return !this.activeBasket.getEntries().isEmpty() && !this.userAlertService.showQuestionDialog(Util.getLabel("commons_selectionOfBehalfUser"), Util.getLabel("basketContainsOrdersEnteringOnBehalf"), new UserAlertService.Flag[0]);
    }
}

