/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.profile;

import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.event.LogoutEvent;
import com.deutscheboerse.comxerv.comtrader.service.profile.RemoteProfileServiceException;
import com.deutscheboerse.comxerv.comtrader.service.profile.RemoteProfileServiceProxy;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.m7.comtrader.remote.profilestorage.v3.ProfileService;
import com.deutscheboerse.m7.comtrader.remote.profilestorage.v3.ProfileServiceException;
import com.deutscheboerse.m7.comtrader.remote.profilestorage.v3.data.Profile;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.joda.time.DateTime;

public class FaultTolerantRemoteProfileService
implements ProfileService {
    private final RemoteProfileServiceProxy remoteProfileService;
    private final UserAlertService userAlertService;
    private final TimeService timeService;
    private volatile DateTime lastFailure;
    protected static final int DONT_SHOW_ERRORS_FOR_MIN = 10;

    @Inject
    public FaultTolerantRemoteProfileService(RemoteProfileServiceProxy remoteProfileService, UserAlertService userAlertService, TimeService timeService, EventBus eventBus) {
        this.remoteProfileService = remoteProfileService;
        this.userAlertService = userAlertService;
        this.timeService = timeService;
        eventBus.register(this);
    }

    @Subscribe
    public void handleLogout(LogoutEvent event) {
        this.lastFailure = null;
    }

    @Override
    public boolean profileExists(String exchangeId, String userName, String environmentId) {
        try {
            return this.remoteProfileService.profileExists(exchangeId, userName, environmentId);
        }
        catch (RemoteProfileServiceException e) {
            this.handleException(e);
            throw new ProfileServiceException(ProfileServiceException.ErrorType.OTHER, e.getMessage(), e);
        }
        catch (ProfileServiceException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public void createProfile(Profile profile) {
        try {
            this.remoteProfileService.createProfile(profile);
        }
        catch (RemoteProfileServiceException e) {
            this.handleException(e);
            throw new ProfileServiceException(ProfileServiceException.ErrorType.OTHER, e.getMessage(), e);
        }
        catch (ProfileServiceException e) {
            if (e.getErrorType() != ProfileServiceException.ErrorType.PROFILE_ALREADY_EXISTS) {
                this.handleException(e);
            }
            throw e;
        }
    }

    @Override
    public Profile loadProfile(String exchangeId, String userName, String environmentId) {
        try {
            return this.remoteProfileService.loadProfile(exchangeId, userName, environmentId);
        }
        catch (RemoteProfileServiceException e) {
            this.handleException(e);
            throw new ProfileServiceException(ProfileServiceException.ErrorType.OTHER, e.getMessage(), e);
        }
        catch (ProfileServiceException e) {
            if (e.getErrorType() != ProfileServiceException.ErrorType.PROFILE_DOESNT_EXIST) {
                this.handleException(e);
            }
            throw e;
        }
    }

    @Override
    public void storeProfile(Profile profile) {
        try {
            this.remoteProfileService.storeProfile(profile);
        }
        catch (RemoteProfileServiceException e) {
            this.handleException(e);
            throw new ProfileServiceException(ProfileServiceException.ErrorType.OTHER, e.getMessage(), e);
        }
        catch (ProfileServiceException e) {
            if (e.getErrorType() != ProfileServiceException.ErrorType.PROFILE_DOESNT_EXIST) {
                this.handleException(e);
            }
            throw e;
        }
    }

    private void handleException(RuntimeException e) {
        DateTime now = this.timeService.getLocalTime();
        if (this.lastFailure == null || this.lastFailure.plusMinutes(10).isBefore(now)) {
            this.userAlertService.showConfirmationDialog(Util.getLabel("commons_error"), Util.getLabel("remote_profile_service_error", e.getMessage()), ExceptionUtils.getStackTrace(e), UserAlertService.Flag.ERROR);
        }
        this.lastFailure = now;
    }
}

