/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.profile;

import com.deutscheboerse.comxerv.comtrader.app.login.MasterLoginModel;
import com.deutscheboerse.comxerv.comtrader.entities.type.MessageSeverity;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.MessagePublisher;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.event.LogoutEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.SaveConfigurationEvent;
import com.deutscheboerse.comxerv.comtrader.service.profile.FaultTolerantRemoteProfileService;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileSerializer;
import com.deutscheboerse.comxerv.comtrader.service.profile.UserProfile;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.m7.comtrader.remote.profilestorage.v3.ProfileService;
import com.deutscheboerse.m7.comtrader.remote.profilestorage.v3.ProfileServiceException;
import com.deutscheboerse.m7.comtrader.remote.profilestorage.v3.data.Profile;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.thoughtworks.xstream.XStreamException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ProfileManager {
    private static final Logger LOG = LoggerFactory.getLogger(ProfileManager.class);
    private final ProfileService profileService;
    private final EventBus eventBus;
    private final ExecutorService executorService;
    private final MessagePublisher messagePublisher;
    private final MasterLoginModel masterLoginModel;
    private final TimeService timeService;
    private final ProfileSerializer profileSerializer;
    private final UserAlertService userAlertService;
    private final FaultTolerantRemoteProfileService remoteProfileService;
    private volatile UserProfile currentProfile;
    private static final String DEFAULT_PROFILE_RESOURCE = "/guisettings/defaultProfile.xml";
    @VisibleForTesting
    private String profileResource = "/guisettings/defaultProfile.xml";

    @Inject
    public ProfileManager(ProfileService profileService, EventBus eventBus, @WorkerExecutor ExecutorService executorService, MessagePublisher messagePublisher, MasterLoginModel masterLoginModel, TimeService timeService, ProfileSerializer profileSerializer, UserAlertService userAlertService, FaultTolerantRemoteProfileService remoteProfileService) {
        this.profileService = profileService;
        this.eventBus = eventBus;
        this.executorService = executorService;
        this.messagePublisher = messagePublisher;
        this.masterLoginModel = masterLoginModel;
        this.timeService = timeService;
        this.profileSerializer = profileSerializer;
        this.userAlertService = userAlertService;
        this.remoteProfileService = remoteProfileService;
        eventBus.register(this);
    }

    @Subscribe
    public void reset(LogoutEvent logoutEvent) {
        this.currentProfile = null;
    }

    public UserProfile getCurrentProfile() {
        return this.currentProfile;
    }

    public Future<UserProfile> loadProfile() {
        return this.executorService.submit(this::loadProfileInternal);
    }

    private UserProfile loadProfileInternal() throws IOException {
        try {
            Profile profile = this.profileService.loadProfile(this.masterLoginModel.getExchangeId(), this.masterLoginModel.getMasterUsername(), this.masterLoginModel.getEnvironmentId());
            this.currentProfile = this.profileSerializer.getUserProfile(profile);
            this.currentProfile.setEnvironment(this.masterLoginModel.getEnvironmentId());
        }
        catch (ProfileServiceException | XStreamException | ClassCastException e) {
            LOG.error("Could not load profile.", e);
            boolean loadDefault = this.userAlertService.showQuestionDialog(Util.getLabel("commons_error"), Util.getLabel("profile_corrupted_error"), UserAlertService.Flag.ERROR);
            if (loadDefault) {
                this.currentProfile = this.getDefaultProfile();
                this.currentProfile.setExchangeId(this.masterLoginModel.getExchangeId());
                this.currentProfile.setUserName(this.masterLoginModel.getMasterUsername());
                this.currentProfile.setEnvironment(this.masterLoginModel.getEnvironmentId());
            }
            throw e;
        }
        return this.currentProfile;
    }

    public Future<UserProfile> loadOrCreateProfile() {
        if (!DEFAULT_PROFILE_RESOURCE.equals(this.profileResource)) {
            return this.executorService.submit(() -> {
                this.currentProfile = this.getDefaultProfile();
                this.currentProfile.setExchangeId(this.masterLoginModel.getExchangeId());
                this.currentProfile.setUserName(this.masterLoginModel.getMasterUsername());
                this.currentProfile.setEnvironment(this.masterLoginModel.getEnvironmentId());
                return this.currentProfile;
            });
        }
        return this.executorService.submit(() -> {
            String environmentId;
            String masterUsername;
            String exchangeId = this.masterLoginModel.getExchangeId();
            if (this.profileService.profileExists(exchangeId, masterUsername = this.masterLoginModel.getMasterUsername(), environmentId = this.masterLoginModel.getEnvironmentId())) {
                LOG.info("Profile {}/{} exists, attempting to load it.", (Object)exchangeId, (Object)masterUsername);
                return this.loadProfileInternal();
            }
            LOG.info("Profile {}/{} does not exist.", (Object)exchangeId, (Object)masterUsername);
            return this.createNewProfile(exchangeId, masterUsername);
        });
    }

    private UserProfile createNewProfile(String exchangeId, String masterUsername) throws IOException {
        LOG.info("Attempting to create a new default profile.");
        UserProfile userProfile = this.getDefaultProfile();
        userProfile.setExchangeId(exchangeId);
        userProfile.setUserName(masterUsername);
        userProfile.setEnvironment(this.masterLoginModel.getEnvironmentId());
        Profile profile = this.profileSerializer.getProfile(userProfile);
        this.profileService.createProfile(profile);
        this.currentProfile = userProfile;
        return this.currentProfile;
    }

    public Future<Boolean> checkProfileExists() {
        return this.executorService.submit(() -> this.profileService.profileExists(this.masterLoginModel.getExchangeId(), this.masterLoginModel.getMasterUsername(), this.masterLoginModel.getEnvironmentId()));
    }

    public Future<UserProfile> loadDefaultProfile() {
        return this.executorService.submit(() -> {
            try {
                UserProfile defaultProfile = this.getDefaultProfile();
                defaultProfile.setExchangeId(this.currentProfile.getExchangeId());
                defaultProfile.setUserName(this.currentProfile.getUserName());
                defaultProfile.setEnvironment(this.currentProfile.getEnvironment());
                this.currentProfile = defaultProfile;
            }
            catch (Exception e) {
                throw new ProfileServiceException(ProfileServiceException.ErrorType.IO_ERROR, "Could not load default profile", e);
            }
            return this.currentProfile;
        });
    }

    protected UserProfile getDefaultProfile() throws IOException {
        URL resourceUrl = this.getClass().getResource(this.profileResource);
        if (resourceUrl != null) {
            try (InputStream defaultProfileStream = ProfileManager.class.getResourceAsStream(this.profileResource);){
                String defaultProfileData = IOUtils.toString(defaultProfileStream, StandardCharsets.UTF_8);
                UserProfile userProfile = this.profileSerializer.loadExportedProfile(defaultProfileData);
                return userProfile;
            }
        }
        File profileFile = new File(this.profileResource);
        if (!profileFile.isFile() || !profileFile.canRead()) {
            throw new IllegalArgumentException("\"" + this.profileResource + "\" is not resource nor file");
        }
        try (FileInputStream defaultProfileStream = new FileInputStream(profileFile);){
            String defaultProfileData = IOUtils.toString((InputStream)defaultProfileStream, StandardCharsets.UTF_8);
            UserProfile userProfile = this.profileSerializer.loadExportedProfile(defaultProfileData);
            return userProfile;
        }
    }

    public void reloadUiWithoutSavingProfile(Runnable reloadUiAction) {
        UserProfile backup = this.currentProfile;
        this.currentProfile = new UserProfile();
        this.gatherConfiguration();
        reloadUiAction.run();
        this.currentProfile = backup;
    }

    public Future<UserProfile> importProfile(File file) {
        return this.executorService.submit(() -> {
            try (FileInputStream inputStream = new FileInputStream(file);){
                UserProfile importedProfile = this.profileSerializer.loadExportedProfile(IOUtils.toString((InputStream)inputStream, StandardCharsets.UTF_8));
                importedProfile.setExchangeId(this.currentProfile.getExchangeId());
                importedProfile.setUserName(this.currentProfile.getUserName());
                importedProfile.setEnvironment(this.currentProfile.getEnvironment());
                this.currentProfile = importedProfile;
            }
            catch (Exception e) {
                throw new ProfileServiceException(ProfileServiceException.ErrorType.IO_ERROR, "Could not import profile", e);
            }
            return this.currentProfile;
        });
    }

    public Future<Void> exportProfile(File file) {
        this.gatherConfiguration();
        UserProfile currentProfileCopy = new UserProfile(this.currentProfile);
        currentProfileCopy.setFormatVersion(this.currentProfile.getFormatVersion());
        return this.executorService.submit(() -> {
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                String profileContent = this.profileSerializer.getProfileContentForExport(currentProfileCopy);
                IOUtils.write(profileContent, (OutputStream)outputStream, StandardCharsets.UTF_8);
                FxUtil.runInFxThread(() -> this.messagePublisher.publishMessage(Util.getLabel("feedback_profile_exported"), MessageSeverity.LOW));
            }
            catch (IOException e) {
                String feedbackProfileExportFailed = Util.getLabel("feedback_profile_export_failed");
                LOG.error(feedbackProfileExportFailed, e);
                FxUtil.runInFxThread(() -> this.messagePublisher.publishMessage(feedbackProfileExportFailed, MessageSeverity.ERROR));
                throw new ProfileServiceException(ProfileServiceException.ErrorType.IO_ERROR, feedbackProfileExportFailed, e);
            }
            return null;
        });
    }

    private void gatherConfiguration() {
        this.eventBus.post(new SaveConfigurationEvent());
    }

    public Future<Void> saveProfile() {
        this.gatherConfiguration();
        return this.executorService.submit(() -> {
            this.currentProfile.setLastProfileSaveTimeStamp(this.timeService.getLocalTime().getMillis());
            this.profileService.storeProfile(this.profileSerializer.getProfile(this.currentProfile));
            return null;
        });
    }

    @VisibleForTesting
    public void setProfileResource(String profileResource) {
        this.profileResource = profileResource;
    }

    @VisibleForTesting
    public boolean remoteProfileExists(String userName) {
        return this.remoteProfileService.profileExists(this.currentProfile.getExchangeId(), userName, this.currentProfile.getEnvironment());
    }
}

