/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.time;

import com.deutscheboerse.comxerv.comtrader.service.time.TimeProvider;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;

public class ShiftedTime
implements TimeProvider {
    private TimeProvider localTime;
    private DateTimeZone timeZone;
    private volatile Duration shift = new Duration(0L);

    public ShiftedTime(TimeProvider localTime) {
        this.localTime = localTime;
        this.timeZone = DateTimeZone.getDefault();
    }

    @Override
    public DateTime getTime() {
        return this.localTime.getTime().plus(this.shift).withZone(this.timeZone);
    }

    public Duration getShift() {
        return this.shift;
    }

    public DateTimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(DateTimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public long update(DateTime currentShiftedTime) {
        Duration oldShift = this.shift;
        this.shift = new Duration(this.localTime.getTime(), currentShiftedTime);
        return this.shift.getMillis() == 0L ? 0L : Math.abs(oldShift.getMillis() - this.shift.getMillis());
    }
}

