/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.time;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.monitoring.Monitor;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.service.event.FullHourEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.LogoutEvent;
import com.deutscheboerse.comxerv.comtrader.service.time.ShiftedTime;
import com.deutscheboerse.comxerv.comtrader.service.time.SystemTime;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeProvider;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.concurrent.atomic.AtomicBoolean;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@Singleton
public class TimeServiceImpl
implements TimeService {
    private static final Logger LOG = LoggerFactory.getLogger(TimeServiceImpl.class);
    private static final Logger PERFORMANCE_LOG = LoggerFactory.getLogger("performance");
    private static final Marker SHIFT_MARKER = MarkerFactory.getMarker("SHIFT");
    private static final int SHIFT_DELTA_WARNING_THRESHOLD = 1000;
    private final TimeProvider localTime;
    private final EventBus eventBus;
    private final Monitor monitor;
    private final ShiftedTime serverTime;
    private DateTimeZone defaultTimeZone;
    private LocalTime lastServerTime;
    private final AtomicBoolean serverTimeIsSynced = new AtomicBoolean(false);

    @Inject
    public TimeServiceImpl(EventBus eventBus, ApplicationContext appContext) {
        this(new SystemTime(), eventBus, DateTimeZone.forID(appContext.getService(ApplicationConfigurationService.class).getApplicationProperty("default.timeZone")), appContext.getService(Monitor.class));
    }

    public TimeServiceImpl(TimeProvider localTime, EventBus eventBus, DateTimeZone defaultTimeZone, Monitor monitor) {
        this.localTime = localTime;
        this.eventBus = eventBus;
        this.eventBus.register(this);
        this.defaultTimeZone = defaultTimeZone;
        this.serverTime = new ShiftedTime(localTime);
        this.monitor = monitor;
    }

    @Override
    public DateTime getLocalTime() {
        return this.localTime.getTime().withZone(this.defaultTimeZone);
    }

    @Override
    public DateTime getServerTime() {
        if (!this.serverTimeIsSynced.get()) {
            LOG.warn("Server time is not available, using local time.");
            this.monitor.connected(false);
            return this.getLocalTime();
        }
        return this.serverTime.getTime();
    }

    @Override
    public void updateServerTime(DateTime dateTime) {
        LOG.debug("Updating server time: {}", (Object)dateTime);
        if (!this.serverTimeIsSynced.get()) {
            this.serverTime.update(dateTime);
            this.serverTimeIsSynced.set(true);
        } else {
            long shiftDelta = this.serverTime.update(dateTime);
            if (PERFORMANCE_LOG.isDebugEnabled()) {
                PERFORMANCE_LOG.debug(SHIFT_MARKER, Long.toString(shiftDelta));
            }
            if (shiftDelta > 1000L) {
                LOG.warn("Big time shift delta detected: {} - (unless this happens during initial loading) is indicates poor messaging performance or an unstable network connection!", (Object)shiftDelta);
            } else {
                LOG.debug("Time shift delta: {}", (Object)shiftDelta);
            }
            this.checkSixFullHour();
        }
        this.lastServerTime = this.serverTime.getTime().toLocalTime();
    }

    private void checkSixFullHour() {
        int currServerTimeHour = this.serverTime.getTime().toLocalTime().getHourOfDay();
        int lastServerTimeHour = this.lastServerTime.getHourOfDay();
        if (currServerTimeHour == 6 && lastServerTimeHour == 5 || currServerTimeHour == 12 && lastServerTimeHour == 11 || currServerTimeHour == 18 && lastServerTimeHour == 17 || currServerTimeHour == 0 && lastServerTimeHour == 23) {
            LOG.info("Sending {} full hour event", (Object)currServerTimeHour);
            this.eventBus.post(new FullHourEvent(currServerTimeHour));
        }
    }

    @Override
    public void updateServerTimeZone(DateTimeZone timeZone) {
        this.serverTime.setTimeZone(timeZone);
    }

    @Override
    public void removeServerTime() {
        this.serverTimeIsSynced.set(false);
    }

    @Subscribe
    public void handleLogout(LogoutEvent logout) {
        this.removeServerTime();
    }

    @Override
    public boolean isInitialServerTimeSynchronizationDone() {
        return this.serverTimeIsSynced.get();
    }
}

