/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.user;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.domain.query.UserQueries;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.Member;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.UserRoles;
import com.deutscheboerse.comxerv.comtrader.entities.type.SuspensionType;
import com.deutscheboerse.comxerv.comtrader.service.AssignmentService;
import com.deutscheboerse.comxerv.comtrader.service.user.MemberService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

@Singleton
public class MemberServiceImpl
implements MemberService {
    private final UserQueries userQueries;
    private final UserService userService;
    private final SmallFastDataModel<String, BalancingGroup> bgDataModel;
    private final AssignmentService assignmentService;
    private static final String[] ON_BEHALF_ROLES = new String[]{"ROLE_USER", "ROLE_BROKER", "ROLE_BALANCE_USER"};

    @Inject
    public MemberServiceImpl(ApplicationContext appContext) {
        this.userService = appContext.getService(UserService.class);
        this.userQueries = appContext.getService(UserQueries.class);
        this.bgDataModel = appContext.getSmallDataModel(BalancingGroup.class);
        this.assignmentService = appContext.getService(AssignmentService.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isMemberForOnBehalf(Member member) {
        if (member.getSuspensionType() != SuspensionType.ACTIVE) {
            return false;
        }
        User ownUser = this.userService.getOwnUser();
        UserRoles ownRoles = ownUser.getRoles();
        String ownMemberId = ownUser.getMemberId();
        if (ownRoles.isTrader() && ownRoles.isOnBehalf()) {
            return ((String)member.getId()).equals(ownMemberId);
        }
        if (ownRoles.isAdmin()) {
            return this.getIdsOfMembersWithAnyActiveTraders().anyMatch(((String)member.getId())::equals);
        }
        if (!ownRoles.isBroker()) return false;
        if (!ownRoles.isOnBehalf()) {
            if (((String)member.getId()).equals(ownMemberId)) return false;
        }
        if (!this.getIdsOfMembersWithAnyActiveTraders().anyMatch(((String)member.getId())::equals)) return false;
        return true;
    }

    private Stream<String> getIdsOfMembersWithAnyActiveTraders() {
        return this.userQueries.findActiveTraders().getAll().map(User::getMemberId);
    }

    @Override
    public Stream<User> getUsersForMember(Member member) {
        if (member != null) {
            return this.userQueries.findUsersByMemberId((String)member.getId(), ON_BEHALF_ROLES).getAll().filter(this::isValidUserForOnBehalf);
        }
        return Stream.empty();
    }

    private boolean isValidUserForOnBehalf(User user) {
        if (!SuspensionType.ACTIVE.equals((Object)user.getSuspensionType())) {
            return false;
        }
        User ownUser = this.userService.getOwnUser();
        if (ownUser == null) {
            return false;
        }
        if (ownUser.getRoles().isAdmin()) {
            return true;
        }
        if (((Integer)ownUser.getId()).equals(user.getId())) {
            return false;
        }
        Set<String> ownAssignedBGs = ownUser.getRoles().isBroker() ? this.assignmentService.getAssignedBgIdsForBroker(ownUser) : ownUser.getBalancingGroupIds();
        Set<String> usersBgs = user.getBalancingGroupIds();
        return ownAssignedBGs.stream().anyMatch(usersBgs::contains);
    }

    @Override
    public Map<String, Set<String>> getProductsAndBGsForMember(String memberId) {
        HashMap<String, Set<String>> productAndBGs = new HashMap<String, Set<String>>();
        this.bgDataModel.getAllEntitiesAsStream().filter(bg -> memberId.equals(bg.getMemberId())).forEach(balancingGroup -> {
            for (String productId : balancingGroup.getProductIds()) {
                Set bgs = productAndBGs.computeIfAbsent(productId, k -> new HashSet());
                bgs.add((String)balancingGroup.getId());
            }
        });
        return productAndBGs;
    }
}

