/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.util.concurrent;

import com.deutscheboerse.comxerv.comtrader.util.concurrent.SlicedRunnable;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SlicedSerialTask<T>
extends SlicedRunnable<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SlicedSerialTask.class);

    public SlicedSerialTask(String taskName, Collection<T> sliceInputs) {
        super(taskName, sliceInputs);
    }

    @Override
    public void run() {
        CopyOnWriteArrayList<RuntimeException> exceptions = new CopyOnWriteArrayList<RuntimeException>();
        int sliceCount = 0;
        for (Object sliceInput : this.sliceInputs) {
            LOG.info("{} ({}/{}): {}", this, ++sliceCount, this.sliceInputs.size(), sliceInput);
            try {
                this.loadData(sliceInput);
            }
            catch (RuntimeException e) {
                exceptions.add(e);
            }
        }
        this.handleExceptions(exceptions);
    }

    protected abstract void loadData(T var1);
}

