/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.m7.trading.api.xjb;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.joda.time.Period;
import org.joda.time.format.ISOPeriodFormat;

public final class DurationConverter {
    private static DatatypeFactory factory;

    private DurationConverter() {
    }

    public static Period parseDuration(String s) {
        if (s != null) {
            Duration duration = factory.newDuration(s);
            return new Period(duration.getSign() * duration.getYears(), duration.getSign() * duration.getMonths(), 0, duration.getSign() * duration.getDays(), duration.getSign() * duration.getHours(), duration.getSign() * duration.getMinutes(), duration.getSign() * duration.getSeconds(), 0);
        }
        return null;
    }

    public static String printDuration(Period period) {
        if (period != null) {
            boolean isPositive = true;
            if (period.getYears() >= 0 && period.getMonths() >= 0 && period.getWeeks() >= 0 && period.getDays() >= 0 && period.getHours() >= 0 && period.getMinutes() >= 0 && period.getSeconds() >= 0 && period.getMillis() >= 0 && DurationConverter.isOneNotNull(period)) {
                isPositive = true;
            } else if (period.getYears() <= 0 && period.getMonths() <= 0 && period.getWeeks() <= 0 && period.getDays() <= 0 && period.getHours() <= 0 && period.getMinutes() <= 0 && period.getSeconds() <= 0 && period.getMillis() <= 0 && DurationConverter.isOneNotNull(period)) {
                isPositive = false;
            } else if (period.getYears() != 0 && period.getMonths() != 0 && period.getWeeks() != 0 && period.getDays() != 0) {
                if (period.toStandardDuration().getMillis() < 0L) {
                    isPositive = false;
                }
            } else {
                throw new IllegalArgumentException("wrong period: " + ISOPeriodFormat.standard().print(period));
            }
            Duration duration = factory.newDuration(isPositive, Math.abs(period.getYears()), Math.abs(period.getMonths()), Math.abs(period.getDays()), Math.abs(period.getHours()), Math.abs(period.getMinutes()), Math.abs(period.getSeconds()));
            return duration.toString();
        }
        return null;
    }

    private static boolean isOneNotNull(Period period) {
        return period.getYears() != 0 || period.getMonths() != 0 || period.getWeeks() != 0 || period.getDays() != 0 || period.getHours() != 0 || period.getMinutes() != 0 || period.getSeconds() != 0 || period.getMillis() == 0;
    }

    static {
        try {
            factory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
    }
}

