/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.ui.jfx.util.binding;

import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Function;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;

public abstract class DependentObservable<S>
implements Observable {
    private final ObservableValue<S> s;
    private final Set<InvalidationListener> listeners;
    private final ObjectProperty<Observable> innerObservable;

    public DependentObservable(ObservableValue<S> s) {
        this.s = s;
        this.listeners = new CopyOnWriteArraySet<InvalidationListener>();
        this.innerObservable = new SimpleObjectProperty<Observable>();
        this.innerObservable.bind((ObservableValue<Observable>)new DependentBinding<Observable>(new Observable[]{s}){

            @Override
            protected Observable computeValue() {
                Object currentOuterValue = DependentObservable.this.s.getValue();
                if (currentOuterValue != null) {
                    return DependentObservable.this.getObservable(currentOuterValue);
                }
                return null;
            }
        });
        this.innerObservable.addListener((ObservableValue<? super T> observableValue, ? super T oldValue, ? super T newValue) -> {
            if (oldValue != null) {
                for (InvalidationListener listener : this.listeners) {
                    oldValue.removeListener(listener);
                }
            }
            if (newValue != null) {
                for (InvalidationListener listener : this.listeners) {
                    newValue.addListener(listener);
                }
            }
            for (InvalidationListener listener : this.listeners) {
                listener.invalidated((Observable)newValue);
            }
        });
    }

    public static <S> DependentObservable<S> get(ObservableValue<S> s, final Function<S, Observable> observableFunction) {
        return new DependentObservable<S>(s){

            @Override
            public Observable getObservable(S s) {
                return (Observable)observableFunction.apply(s);
            }
        };
    }

    @Override
    public void addListener(InvalidationListener invalidationListener) {
        this.listeners.add(invalidationListener);
        Observable currentInnerObservable = (Observable)this.innerObservable.getValue();
        if (currentInnerObservable != null) {
            currentInnerObservable.addListener(invalidationListener);
        }
    }

    @Override
    public void removeListener(InvalidationListener invalidationListener) {
        this.listeners.remove(invalidationListener);
        Observable currentInnerObservable = (Observable)this.innerObservable.getValue();
        if (currentInnerObservable != null) {
            currentInnerObservable.removeListener(invalidationListener);
        }
    }

    public abstract Observable getObservable(S var1);
}

