/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.ui.jfx.util.control.table;

import com.deutscheboerse.ui.jfx.util.StyleUtil;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.geometry.Pos;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;
import javafx.util.Callback;

public class TextWrappingTableCellFactory<S>
implements Callback<TableColumn<S, String>, TableCell<S, String>> {
    private Pos alignment = Pos.CENTER;

    @Override
    public TableCell<S, String> call(TableColumn<S, String> column) {
        TextWrapTableCell cell = new TextWrapTableCell(column.widthProperty());
        cell.setAlignment(this.alignment);
        return cell;
    }

    public Pos getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Pos alignment) {
        this.alignment = alignment;
    }

    private static final class TextWrapTableCell<S>
    extends TableCell<S, String> {
        private final Text text;
        private final InvalidationListener updateWrappingWidthListener = this::updateWrappingWidth;

        public TextWrapTableCell(ReadOnlyDoubleProperty columnWidth) {
            columnWidth.addListener(new WeakInvalidationListener(this.updateWrappingWidthListener));
            this.paddingProperty().addListener(this.updateWrappingWidthListener);
            this.text = new Text();
            this.text.fillProperty().bind(this.textFillProperty());
            HBox box = new HBox();
            box.getChildren().add(this.text);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            this.setGraphic(box);
            StyleUtil.addStyleClass(this, "text-wrapping-table-cell");
            this.updateWrappingWidth(null);
        }

        @Override
        protected void updateItem(String item, boolean empty) {
            super.updateItem(item, empty);
            this.text.setText(item);
        }

        private void updateWrappingWidth(Observable observable2) {
            double leftPadding = this.getPadding() != null ? this.getPadding().getLeft() : 0.0;
            double rightPadding = this.getPadding() != null ? this.getPadding().getRight() : 0.0;
            double columnWidth = this.getTableColumn() != null ? this.getTableColumn().getWidth() : 0.0;
            this.text.setWrappingWidth(columnWidth - leftPadding - (rightPadding += 5.0));
        }
    }
}

