/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.application.preferences;

import com.sun.javafx.application.preferences.ChangedValue;
import com.sun.javafx.util.Logging;
import com.sun.javafx.util.Utils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javafx.application.ColorScheme;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectPropertyBase;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.scene.paint.Color;

final class PreferenceProperties {
    private final ColorProperty backgroundColor = new ColorProperty("backgroundColor", Color.WHITE);
    private final ColorProperty foregroundColor = new ColorProperty("foregroundColor", Color.BLACK);
    private final ColorProperty accentColor = new ColorProperty("accentColor", Color.rgb(21, 126, 251));
    private final List<ColorProperty> allColors = List.of(this.backgroundColor, this.foregroundColor, this.accentColor);
    private final ColorSchemeProperty colorScheme = new ColorSchemeProperty();
    private final Object bean;

    PreferenceProperties(Object object) {
        this.bean = object;
    }

    public ReadOnlyObjectProperty<ColorScheme> colorSchemeProperty() {
        return this.colorScheme.getReadOnlyProperty();
    }

    public ColorScheme getColorScheme() {
        return (ColorScheme)((Object)this.colorScheme.get());
    }

    public void setColorScheme(ColorScheme colorScheme) {
        this.colorScheme.setValueOverride(colorScheme);
    }

    public ReadOnlyObjectProperty<Color> backgroundColorProperty() {
        return this.backgroundColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor.get();
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor.setValueOverride(color);
    }

    public ReadOnlyObjectProperty<Color> foregroundColorProperty() {
        return this.foregroundColor;
    }

    public Color getForegroundColor() {
        return this.foregroundColor.get();
    }

    public void setForegroundColor(Color color) {
        this.foregroundColor.setValueOverride(color);
    }

    public ReadOnlyObjectProperty<Color> accentColorProperty() {
        return this.accentColor;
    }

    public Color getAccentColor() {
        return this.accentColor.get();
    }

    public void setAccentColor(Color color) {
        this.accentColor.setValueOverride(color);
    }

    public void update(Map<String, ChangedValue> map, Map<String, String> map2) {
        block0: for (Map.Entry<String, ChangedValue> entry : map.entrySet()) {
            String string = map2.get(entry.getKey());
            if (string == null) continue;
            for (ColorProperty colorProperty : this.allColors) {
                if (!colorProperty.getName().equals(string)) continue;
                this.updateColorProperty(colorProperty, entry.getValue().newValue());
                continue block0;
            }
        }
        this.fireValueChangedIfNecessary();
    }

    private void updateColorProperty(ColorProperty colorProperty, Object object) {
        if (object instanceof Color) {
            Color color = (Color)object;
            colorProperty.setValue(color);
        } else {
            if (object != null) {
                Logging.getJavaFXLogger().warning("Unexpected value of " + colorProperty.getName() + " platform preference, using default value instead (expected = " + Color.class.getName() + ", actual = " + object.getClass().getName() + ")");
            }
            colorProperty.setValue(null);
        }
    }

    private void fireValueChangedIfNecessary() {
        for (ColorProperty colorProperty : this.allColors) {
            colorProperty.fireValueChangedIfNecessary();
        }
    }

    private final class ColorProperty
    extends ReadOnlyObjectPropertyBase<Color> {
        private final String name;
        private final Color defaultValue;
        private Color overrideValue;
        private Color platformValue;
        private Color effectiveValue;
        private Color lastEffectiveValue;

        ColorProperty(String string, Color color) {
            this.name = string;
            this.defaultValue = color;
            this.platformValue = color;
            this.effectiveValue = color;
            this.lastEffectiveValue = color;
        }

        @Override
        public Object getBean() {
            return PreferenceProperties.this.bean;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Color get() {
            return this.effectiveValue;
        }

        public void setValue(Color color) {
            this.platformValue = color;
            this.updateEffectiveValue();
        }

        public void setValueOverride(Color color) {
            this.overrideValue = color;
            this.updateEffectiveValue();
            this.fireValueChangedEvent();
        }

        private void updateEffectiveValue() {
            this.effectiveValue = Objects.requireNonNullElse(this.overrideValue != null ? this.overrideValue : this.platformValue, this.defaultValue);
        }

        void fireValueChangedIfNecessary() {
            if (!Objects.equals(this.lastEffectiveValue, this.effectiveValue)) {
                this.lastEffectiveValue = this.effectiveValue;
                this.fireValueChangedEvent();
            }
        }
    }

    private class ColorSchemeProperty
    extends ReadOnlyObjectWrapper<ColorScheme> {
        private ColorScheme colorSchemeOverride;

        ColorSchemeProperty() {
            super(PreferenceProperties.this.bean, "colorScheme");
            InvalidationListener invalidationListener = observable2 -> this.update();
            PreferenceProperties.this.backgroundColor.addListener(invalidationListener);
            PreferenceProperties.this.foregroundColor.addListener(invalidationListener);
            this.update();
        }

        public void setValueOverride(ColorScheme colorScheme) {
            this.colorSchemeOverride = colorScheme;
            this.update();
        }

        private void update() {
            if (this.colorSchemeOverride != null) {
                this.set(this.colorSchemeOverride);
            } else {
                Color color = PreferenceProperties.this.backgroundColor.get();
                Color color2 = PreferenceProperties.this.foregroundColor.get();
                boolean bl = Utils.calculateBrightness(color) < Utils.calculateBrightness(color2);
                this.set(bl ? ColorScheme.DARK : ColorScheme.LIGHT);
            }
        }
    }
}

