/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmedia.locator;

import com.sun.media.jfxmedia.MediaError;
import com.sun.media.jfxmedia.MediaException;
import com.sun.media.jfxmedia.locator.ConnectionHolder;
import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmediaimpl.MediaUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.stream.Stream;

final class HLSConnectionHolder
extends ConnectionHolder {
    private boolean isAudioExtStream = false;
    private HLSConnectionHolder audioConnectionHolder = null;
    private URLConnection urlConnection = null;
    private URLConnection headerConnection = null;
    private ReadableByteChannel headerChannel = null;
    private final PlaylistLoader playlistLoader;
    private VariantPlaylist variantPlaylist = null;
    private Playlist currentPlaylist = null;
    private Playlist newCurrentPlaylist = null;
    private final Object newPlaylistLock = new Object();
    private boolean isBitrateAdjustable = false;
    private boolean hasAudioExtStream = false;
    private long readStartTime = -1L;
    private boolean sendHeader = false;
    private boolean isInitialized = false;
    private int duration = -1;
    private int segmentStartTimeAfterSeek = -1;
    static final long HLS_VALUE_FLOAT_MULTIPLIER = 1000L;
    static final int HLS_PROP_GET_DURATION = 1;
    static final int HLS_PROP_GET_HLS_MODE = 2;
    static final int HLS_PROP_GET_MIMETYPE = 3;
    static final int HLS_PROP_LOAD_SEGMENT = 4;
    static final int HLS_PROP_SEGMENT_START_TIME = 5;
    static final int HLS_PROP_HAS_AUDIO_EXT_STREAM = 6;
    static final int HLS_VALUE_MIMETYPE_UNKNOWN = -1;
    static final int HLS_VALUE_MIMETYPE_MP2T = 1;
    static final int HLS_VALUE_MIMETYPE_MP3 = 2;
    static final int HLS_VALUE_MIMETYPE_FMP4 = 3;
    static final int HLS_VALUE_MIMETYPE_AAC = 4;
    static final String CHARSET_UTF_8 = "UTF-8";
    static final String CHARSET_US_ASCII = "US-ASCII";

    HLSConnectionHolder(URI uRI) {
        this.playlistLoader = new PlaylistLoader();
        this.playlistLoader.setPlaylistURI(uRI);
        this.init();
    }

    HLSConnectionHolder(Playlist playlist, boolean bl) {
        this.playlistLoader = null;
        this.currentPlaylist = playlist;
        this.isAudioExtStream = bl;
    }

    private void init() {
        this.playlistLoader.putState(0);
        this.playlistLoader.start();
    }

    @Override
    public int readNextBlock() throws IOException {
        int n;
        if (this.isBitrateAdjustable && this.readStartTime == -1L) {
            this.readStartTime = System.currentTimeMillis();
        }
        if (this.headerChannel != null) {
            this.buffer.rewind();
            if (this.buffer.limit() < this.buffer.capacity()) {
                this.buffer.limit(this.buffer.capacity());
            }
            if ((n = this.headerChannel.read(this.buffer)) == -1) {
                this.resetHeaderConnection();
            } else {
                return n;
            }
        }
        n = super.readNextBlock();
        if (this.isBitrateAdjustable && n == -1) {
            long l = System.currentTimeMillis() - this.readStartTime;
            this.readStartTime = -1L;
            this.adjustBitrate(l);
        } else if (this.isAudioExtStream && n == -1) {
            this.adjustBitrateAudioExt();
        }
        return n;
    }

    @Override
    int readBlock(long l, int n) throws IOException {
        throw new IOException();
    }

    @Override
    boolean needBuffer() {
        return true;
    }

    @Override
    boolean isSeekable() {
        return true;
    }

    @Override
    boolean isRandomAccess() {
        return false;
    }

    @Override
    public long seek(long l) {
        if (!this.isReady()) {
            return -1L;
        }
        if (this.hasAudioExtStream && l != 0L) {
            if (this.getAudioStream() == null || this.getAudioStream().getCurrentPlaylist() == null) {
                return -1L;
            }
            double d = this.getAudioStream().getCurrentPlaylist().seekGetStartTime(l);
            if (this.currentPlaylist.seek((long)d) == -1.0) {
                return -1L;
            }
            return (long)(d * 1000.0);
        }
        return (long)(this.currentPlaylist.seek(l) * 1000.0);
    }

    @Override
    public void closeConnection() {
        this.currentPlaylist.close();
        super.closeConnection();
        this.resetConnection();
        this.playlistLoader.putState(1);
    }

    @Override
    int property(int n, int n2) {
        if (!this.isReady()) {
            return -1;
        }
        switch (n) {
            case 1: {
                return this.duration;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return this.currentPlaylist.getMimeType();
            }
            case 4: {
                return this.loadNextSegment();
            }
            case 5: {
                int n3 = -1;
                if (this.segmentStartTimeAfterSeek != -1) {
                    n3 = this.segmentStartTimeAfterSeek;
                    this.segmentStartTimeAfterSeek = -1;
                } else {
                    n3 = (int)(this.currentPlaylist.getMediaFileStartTime() * 1000.0);
                }
                return n3;
            }
            case 6: {
                return this.hasAudioExtStream ? 1 : 0;
            }
        }
        return -1;
    }

    @Override
    public HLSConnectionHolder getAudioStream() {
        if (!this.hasAudioExtStream) {
            return null;
        }
        if (this.audioConnectionHolder != null) {
            return this.audioConnectionHolder;
        }
        if (this.variantPlaylist != null && this.currentPlaylist != null) {
            String string = this.currentPlaylist.getAudioGroupID();
            Playlist playlist = this.variantPlaylist.getAudioExtPlaylist(string);
            this.audioConnectionHolder = new HLSConnectionHolder(playlist, true);
            return this.audioConnectionHolder;
        }
        return null;
    }

    private synchronized boolean isReady() {
        if (this.playlistLoader != null && !this.playlistLoader.waitForReady()) {
            return false;
        }
        if (this.isInitialized) {
            return true;
        }
        if (this.playlistLoader != null) {
            this.variantPlaylist = this.playlistLoader.getVariantPlaylist();
            this.currentPlaylist = this.playlistLoader.getCurrentPlaylist();
        }
        if (this.variantPlaylist != null) {
            this.currentPlaylist = this.variantPlaylist.getPlaylist(0);
            this.isBitrateAdjustable = true;
            boolean bl = this.hasAudioExtStream = !this.variantPlaylist.getAudioExtMedia().isEmpty();
        }
        if (this.currentPlaylist != null && !this.isAudioExtStream) {
            this.duration = (int)(this.currentPlaylist.getDuration() * 1000.0);
            if (this.hasAudioExtStream) {
                HLSConnectionHolder hLSConnectionHolder;
                int n = (int)(this.variantPlaylist.getAudioExtMedia().get(0).getPlaylist().getDuration() * 1000.0);
                if (this.duration < n) {
                    this.duration = n;
                }
                if ((hLSConnectionHolder = this.getAudioStream()) != null) {
                    hLSConnectionHolder.setDuration(this.duration);
                }
            }
        }
        if (this.currentPlaylist != null && this.currentPlaylist.isFragmentedMP4()) {
            this.sendHeader = true;
            this.currentPlaylist.setMediaFileIndex(0);
        }
        this.isInitialized = true;
        return true;
    }

    private void resetConnection() {
        super.closeConnection();
        this.resetHeaderConnection();
        Locator.closeConnection(this.urlConnection);
        this.urlConnection = null;
    }

    private void resetHeaderConnection() {
        try {
            if (this.headerChannel != null) {
                this.headerChannel.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.headerChannel = null;
        }
        Locator.closeConnection(this.headerConnection);
        this.headerConnection = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNewCurrentPlaylist(Playlist playlist) {
        Object object = this.newPlaylistLock;
        synchronized (object) {
            if (this.currentPlaylist != playlist) {
                this.newCurrentPlaylist = playlist;
            }
        }
    }

    void setDuration(int n) {
        this.duration = n;
    }

    private int loadNextSegment() {
        URI uRI;
        String string;
        this.resetConnection();
        int n = 0;
        if (this.sendHeader) {
            string = this.currentPlaylist.getHeaderFile();
            if (string == null) {
                return -1;
            }
            try {
                uRI = new URI(string);
                this.headerConnection = uRI.toURL().openConnection();
                this.headerChannel = this.openHeaderChannel();
                n = this.headerConnection.getContentLength();
            }
            catch (IOException | URISyntaxException exception) {
                return -1;
            }
            this.sendHeader = false;
        }
        if ((string = this.currentPlaylist.getNextMediaFile()) == null) {
            if (this.currentPlaylist.isFragmentedMP4()) {
                this.sendHeader = true;
            }
            return -1;
        }
        try {
            uRI = new URI(string);
            this.urlConnection = uRI.toURL().openConnection();
            this.channel = this.openChannel();
        }
        catch (IOException | URISyntaxException exception) {
            return -1;
        }
        if (this.currentPlaylist.isCurrentMediaFileDiscontinuity()) {
            return -1 * (this.urlConnection.getContentLength() + n);
        }
        return this.urlConnection.getContentLength() + n;
    }

    private ReadableByteChannel openChannel() throws IOException {
        return Channels.newChannel(this.urlConnection.getInputStream());
    }

    private ReadableByteChannel openHeaderChannel() throws IOException {
        return Channels.newChannel(this.headerConnection.getInputStream());
    }

    private void adjustBitrate(long l) {
        int n = (int)((long)this.urlConnection.getContentLength() * 8L * 1000L / l);
        Playlist playlist = this.variantPlaylist.getPlaylistBasedOnBitrate(n);
        if (playlist != null && playlist != this.currentPlaylist) {
            if (this.currentPlaylist.isLive()) {
                playlist.update(this.currentPlaylist.getNextMediaFile());
                this.playlistLoader.setReloadPlaylist(playlist);
            }
            playlist.setForceDiscontinuity(true);
            playlist.setMediaFileIndex(this.currentPlaylist.getMediaFileIndex());
            this.currentPlaylist = playlist;
            if (this.currentPlaylist.isFragmentedMP4()) {
                this.sendHeader = true;
            }
            if (this.getAudioStream() != null) {
                String string = this.currentPlaylist.getAudioGroupID();
                Playlist playlist2 = this.variantPlaylist.getAudioExtPlaylist(string);
                this.getAudioStream().setNewCurrentPlaylist(playlist2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustBitrateAudioExt() {
        Object object = this.newPlaylistLock;
        synchronized (object) {
            if (this.newCurrentPlaylist != null && this.newCurrentPlaylist != this.currentPlaylist) {
                if (this.currentPlaylist.isLive()) {
                    this.newCurrentPlaylist.update(this.currentPlaylist.getNextMediaFile());
                    this.playlistLoader.setReloadAudioExtPlaylist(this.newCurrentPlaylist);
                }
                this.newCurrentPlaylist.setForceDiscontinuity(true);
                this.newCurrentPlaylist.setMediaFileIndex(this.currentPlaylist.getMediaFileIndex());
                this.currentPlaylist = this.newCurrentPlaylist;
                if (this.currentPlaylist.isFragmentedMP4()) {
                    this.sendHeader = true;
                }
                this.newCurrentPlaylist = null;
            }
        }
    }

    static String stripParameters(String string) {
        int n = string.indexOf(63);
        if (n > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    Playlist getCurrentPlaylist() {
        return this.currentPlaylist;
    }

    private static class VariantPlaylist {
        private URI playlistURI = null;
        private final List<ExtStreamInf> extStreamInf = new ArrayList<ExtStreamInf>();
        private final List<AudioExtMedia> audioExtMedia = new ArrayList<AudioExtMedia>();
        private final List<Integer> playlistBitrates = new ArrayList<Integer>();

        VariantPlaylist(URI uRI) {
            this.playlistURI = uRI;
        }

        void addExtStreamInf(ExtStreamInf extStreamInf) {
            try {
                extStreamInf.setPlaylistURI(this.locationToURI(extStreamInf.getLocation()));
            }
            catch (MalformedURLException | URISyntaxException exception) {
                throw new MediaException("Invalid HLS playlist");
            }
            this.extStreamInf.add(extStreamInf);
        }

        List<ExtStreamInf> getExtStreamInf() {
            return this.extStreamInf;
        }

        void validateExtStreamInf() {
            String string = null;
            boolean bl = false;
            Iterator<ExtStreamInf> iterator2 = this.extStreamInf.iterator();
            while (iterator2.hasNext()) {
                ExtStreamInf extStreamInf2 = iterator2.next();
                Playlist playlist = extStreamInf2.getPlaylist();
                if (playlist == null) {
                    iterator2.remove();
                    continue;
                }
                if (string == null) {
                    string = playlist.getMediaFileExtension();
                    bl = extStreamInf2.getAudioGroupID() != null;
                    continue;
                }
                if (!string.equals(playlist.getMediaFileExtension())) {
                    iterator2.remove();
                }
                if (!bl || extStreamInf2.getAudioGroupID() != null) continue;
                iterator2.remove();
            }
            if (this.extStreamInf.isEmpty()) {
                throw new MediaException("Invalid HLS playlist");
            }
            this.extStreamInf.forEach(extStreamInf -> this.playlistBitrates.add(extStreamInf.getBitrate()));
        }

        void addAudioExtMedia(AudioExtMedia audioExtMedia) {
            try {
                audioExtMedia.setPlaylistURI(this.locationToURI(audioExtMedia.getLocation()));
            }
            catch (MalformedURLException | URISyntaxException exception) {
                throw new MediaException("Invalid HLS playlist");
            }
            this.audioExtMedia.add(audioExtMedia);
        }

        List<AudioExtMedia> getAudioExtMedia() {
            return this.audioExtMedia;
        }

        void validateAudioExtMedia() {
            String string = null;
            Iterator<AudioExtMedia> iterator2 = this.audioExtMedia.iterator();
            while (iterator2.hasNext()) {
                AudioExtMedia audioExtMedia = iterator2.next();
                Playlist playlist = audioExtMedia.getPlaylist();
                if (playlist == null) {
                    iterator2.remove();
                    continue;
                }
                if (string == null) {
                    string = playlist.getMediaFileExtension();
                    continue;
                }
                if (string.equals(playlist.getMediaFileExtension())) continue;
                iterator2.remove();
            }
        }

        Playlist getPlaylist(int n) {
            if (n < 0 || n >= this.extStreamInf.size()) {
                return null;
            }
            return this.extStreamInf.get(n).getPlaylist();
        }

        Playlist getAudioExtPlaylist(String string) {
            if (string == null || this.audioExtMedia.isEmpty()) {
                return null;
            }
            AudioExtMedia audioExtMedia2 = this.audioExtMedia.stream().filter(audioExtMedia -> audioExtMedia.getGroupID().equals(string)).findFirst().orElse(null);
            return audioExtMedia2 == null ? null : audioExtMedia2.getPlaylist();
        }

        private URI locationToURI(String string) throws URISyntaxException, MalformedURLException {
            if (string.startsWith("http://") || string.startsWith("https://")) {
                return new URI(string);
            }
            return new URI(this.playlistURI.toURL().toString().substring(0, this.playlistURI.toURL().toString().lastIndexOf("/") + 1) + string);
        }

        Playlist getPlaylistBasedOnBitrate(int n) {
            int n2;
            int n3;
            int n4 = -1;
            int n5 = 0;
            for (n3 = 0; n3 < this.playlistBitrates.size(); ++n3) {
                n2 = this.playlistBitrates.get(n3);
                if (n2 >= n) continue;
                if (n4 != -1) {
                    if (n2 <= n5) continue;
                    n5 = n2;
                    n4 = n3;
                    continue;
                }
                n4 = n3;
            }
            if (n4 == -1) {
                for (n3 = 0; n3 < this.playlistBitrates.size(); ++n3) {
                    n2 = this.playlistBitrates.get(n3);
                    if (n2 >= n5 && n4 != -1) continue;
                    n5 = n2;
                    n4 = n3;
                }
            }
            return this.getPlaylist(n4);
        }
    }

    private static class Playlist {
        private boolean isLive = false;
        private volatile boolean isLiveWaiting = false;
        private volatile boolean isLiveStop = false;
        private long targetDuration = 0L;
        private URI playlistURI = null;
        private final Object lock = new Object();
        private final List<String> mediaFiles = new ArrayList<String>();
        final List<Double> mediaFilesStartTimes = new ArrayList<Double>();
        private final List<Boolean> mediaFilesDiscontinuities = new ArrayList<Boolean>();
        private boolean needBaseURI = true;
        private String baseURI = null;
        private double startTime = 0.0;
        private double duration = 0.0;
        private int sequenceNumber = -1;
        private int sequenceNumberStart = -1;
        private boolean sequenceNumberUpdated = false;
        private boolean forceDiscontinuity = false;
        private int mimeType = -1;
        private int mediaFileIndex = -1;
        private final Semaphore liveSemaphore = new Semaphore(0);
        private boolean isPlaylistClosed = false;
        private boolean isVideoStreamFragmentedMP4 = false;
        private long videoStreamTargetDuration = 0L;
        private String audioGroupID = null;

        Playlist(URI uRI) {
            this.playlistURI = uRI;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void update(String string) {
            PlaylistParser playlistParser = new PlaylistParser();
            playlistParser.setPlaylist(this);
            playlistParser.load(this.playlistURI);
            this.isLive = playlistParser.isLivePlaylist();
            if (this.isLive) {
                this.duration = -1.0;
            }
            if (string != null) {
                Object object = this.lock;
                synchronized (object) {
                    for (int i = 0; i < this.mediaFiles.size(); ++i) {
                        String string2 = this.mediaFiles.get(i);
                        if (!string.endsWith(string2)) continue;
                        this.mediaFileIndex = i - 1;
                        break;
                    }
                }
            }
        }

        void setMediaFileIndex(int n) {
            this.mediaFileIndex = n;
        }

        int getMediaFileIndex() {
            return this.mediaFileIndex;
        }

        boolean isLive() {
            return this.isLive;
        }

        boolean isFragmentedMP4() {
            return this.getMimeType() == 3;
        }

        void setTargetDuration(long l) {
            this.targetDuration = l;
        }

        long getTargetDuration() {
            return this.targetDuration;
        }

        void setVideoStreamTargetDuration(long l) {
            this.videoStreamTargetDuration = l;
        }

        void setIsVideoStreamFragmentedMP4(boolean bl) {
            this.isVideoStreamFragmentedMP4 = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addMediaFile(String string, double d, boolean bl) {
            Object object = this.lock;
            synchronized (object) {
                if (this.needBaseURI) {
                    this.setBaseURI(this.playlistURI.toString(), string);
                }
                if (this.isLive) {
                    if (this.sequenceNumberUpdated) {
                        int n = this.mediaFiles.indexOf(string);
                        if (n != -1) {
                            for (int i = 0; i < n; ++i) {
                                this.mediaFiles.remove(0);
                                this.mediaFilesDiscontinuities.remove(0);
                                if (this.mediaFileIndex == -1) {
                                    this.forceDiscontinuity = true;
                                }
                                if (this.mediaFileIndex < 0) continue;
                                --this.mediaFileIndex;
                            }
                        }
                        this.sequenceNumberUpdated = false;
                    }
                    if (this.mediaFiles.contains(string)) {
                        return;
                    }
                }
                this.mediaFiles.add(string);
                this.mediaFilesDiscontinuities.add(bl);
                if (this.isLive) {
                    if (this.isLiveWaiting) {
                        this.liveSemaphore.release();
                    }
                } else {
                    this.mediaFilesStartTimes.add(this.startTime);
                    this.startTime += d;
                    if (this.mediaFiles.size() == 1) {
                        if (!this.isFragmentedMP4()) {
                            this.duration += d;
                        }
                    } else {
                        this.duration += d;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String getNextMediaFile() {
            Object object;
            if (this.isLive) {
                object = this.lock;
                synchronized (object) {
                    this.isLiveWaiting = this.mediaFileIndex + 1 >= this.mediaFiles.size();
                }
                if (this.isLiveWaiting) {
                    try {
                        this.liveSemaphore.acquire();
                        this.isLiveWaiting = false;
                        if (this.isLiveStop) {
                            this.isLiveStop = false;
                            return null;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        this.isLiveWaiting = false;
                        return null;
                    }
                }
                if (this.isPlaylistClosed) {
                    return null;
                }
            }
            object = this.lock;
            synchronized (object) {
                ++this.mediaFileIndex;
                if (this.mediaFileIndex < this.mediaFiles.size()) {
                    if (this.baseURI != null) {
                        return this.baseURI + this.mediaFiles.get(this.mediaFileIndex);
                    }
                    return this.mediaFiles.get(this.mediaFileIndex);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String getHeaderFile() {
            Object object = this.lock;
            synchronized (object) {
                if (this.mediaFiles.size() > 0) {
                    if (this.baseURI != null) {
                        return this.baseURI + this.mediaFiles.get(0);
                    }
                    return this.mediaFiles.get(0);
                }
                return null;
            }
        }

        double getMediaFileStartTime() {
            return this.getMediaFileStartTime(this.mediaFileIndex);
        }

        double getMediaFileStartTime(int n) {
            if (n >= 0 && n < this.mediaFilesStartTimes.size()) {
                if (this.isVideoStreamFragmentedMP4 && !this.isFragmentedMP4() && n != 0) {
                    return this.mediaFilesStartTimes.get(n) + (double)this.videoStreamTargetDuration;
                }
                return this.mediaFilesStartTimes.get(n);
            }
            return -1.0;
        }

        double getDuration() {
            return this.duration;
        }

        void setForceDiscontinuity(boolean bl) {
            this.forceDiscontinuity = bl;
        }

        boolean isCurrentMediaFileDiscontinuity() {
            if (this.forceDiscontinuity) {
                this.forceDiscontinuity = false;
                return true;
            }
            return this.mediaFilesDiscontinuities.get(this.mediaFileIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        double seekGetStartTime(long l) {
            Object object = this.lock;
            synchronized (object) {
                int n = 0;
                if (this.isLive) {
                    if (l == 0L) {
                        return 0.0;
                    }
                } else {
                    l += this.targetDuration / 2000L;
                    int n2 = this.mediaFilesStartTimes.size();
                    for (int i = 0; i < n2; ++i) {
                        if (!((double)l >= this.mediaFilesStartTimes.get(i))) continue;
                        if (i + 1 < n2) {
                            if (!((double)l < this.mediaFilesStartTimes.get(i + 1))) continue;
                            n = this.isFragmentedMP4() ? i : i - 1;
                            if (l == 0L && this.isFragmentedMP4()) {
                                return 0.0;
                            }
                            return this.getMediaFileStartTime(n + 1);
                        }
                        if ((double)(l - this.targetDuration / 2000L) < this.duration) {
                            n = this.isFragmentedMP4() ? i : i - 1;
                            return this.getMediaFileStartTime(n + 1);
                        }
                        if (Double.compare(l - this.targetDuration / 2000L, this.duration) != 0) continue;
                        return this.duration;
                    }
                }
            }
            return -1.0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        double seek(long l) {
            Object object = this.lock;
            synchronized (object) {
                if (this.isLive) {
                    if (l == 0L) {
                        this.mediaFileIndex = this.isFragmentedMP4() ? 0 : -1;
                        if (this.isLiveWaiting) {
                            this.isLiveStop = true;
                            this.liveSemaphore.release();
                        }
                        return 0.0;
                    }
                } else {
                    l += this.targetDuration / 2000L;
                    int n = this.mediaFilesStartTimes.size();
                    for (int i = 0; i < n; ++i) {
                        if (!((double)l >= this.mediaFilesStartTimes.get(i))) continue;
                        if (i + 1 < n) {
                            if (!((double)l < this.mediaFilesStartTimes.get(i + 1))) continue;
                            this.mediaFileIndex = this.isFragmentedMP4() ? i : i - 1;
                            if (l == 0L && this.isFragmentedMP4()) {
                                return 0.0;
                            }
                            return this.getMediaFileStartTime(this.mediaFileIndex + 1);
                        }
                        if ((double)(l - this.targetDuration / 2000L) < this.duration) {
                            this.mediaFileIndex = this.isFragmentedMP4() ? i : i - 1;
                            return this.getMediaFileStartTime(this.mediaFileIndex + 1);
                        }
                        if (Double.compare(l - this.targetDuration / 2000L, this.duration) != 0) continue;
                        return this.duration;
                    }
                }
            }
            return -1.0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getMimeType() {
            Object object = this.lock;
            synchronized (object) {
                if (this.mimeType == -1 && this.mediaFiles.size() > 0) {
                    if (HLSConnectionHolder.stripParameters(this.mediaFiles.get(0)).endsWith(".ts")) {
                        this.mimeType = 1;
                    } else if (HLSConnectionHolder.stripParameters(this.mediaFiles.get(0)).endsWith(".mp3")) {
                        this.mimeType = 2;
                    } else if (HLSConnectionHolder.stripParameters(this.mediaFiles.get(0)).endsWith(".mp4") || HLSConnectionHolder.stripParameters(this.mediaFiles.get(0)).endsWith(".m4s")) {
                        this.mimeType = 3;
                    } else if (HLSConnectionHolder.stripParameters(this.mediaFiles.get(0)).endsWith(".aac")) {
                        this.mimeType = 4;
                    }
                }
            }
            return this.mimeType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String getMediaFileExtension() {
            Object object = this.lock;
            synchronized (object) {
                String string;
                int n;
                if (this.mediaFiles.size() > 0 && (n = (string = HLSConnectionHolder.stripParameters(this.mediaFiles.get(0))).lastIndexOf(".")) != -1) {
                    return string.substring(n);
                }
            }
            return null;
        }

        boolean setSequenceNumber(int n) {
            if (this.sequenceNumberStart == -1) {
                this.sequenceNumberStart = n;
            } else if (this.sequenceNumber != n) {
                this.sequenceNumberUpdated = true;
                this.sequenceNumber = n;
            } else {
                return false;
            }
            return true;
        }

        void close() {
            if (this.isLive) {
                this.isPlaylistClosed = true;
                this.liveSemaphore.release();
            }
        }

        private void setBaseURI(String string, String string2) {
            if (!string2.startsWith("http://") && !string2.startsWith("https://")) {
                this.baseURI = string.substring(0, string.lastIndexOf("/") + 1);
            }
            this.needBaseURI = false;
        }

        void setAudioGroupID(String string) {
            this.audioGroupID = string;
        }

        String getAudioGroupID() {
            return this.audioGroupID;
        }
    }

    private static class PlaylistLoader
    extends Thread {
        public static final int STATE_INIT = 0;
        public static final int STATE_EXIT = 1;
        public static final int STATE_RELOAD_PLAYLIST = 2;
        private final BlockingQueue<Integer> stateQueue = new LinkedBlockingQueue<Integer>();
        private URI playlistURI = null;
        private Playlist reloadPlaylist = null;
        private Playlist reloadAudioExtPlaylist = null;
        private final Object reloadLock = new Object();
        private volatile boolean stopped = false;
        private final CountDownLatch readySignal = new CountDownLatch(1);
        private VariantPlaylist variantPlaylist = null;
        private Playlist currentPlaylist = null;

        PlaylistLoader() {
            this.setName("JFXMedia HLS Playlist Thread");
            this.setDaemon(true);
        }

        boolean waitForReady() {
            try {
                this.readySignal.await();
                return true;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }

        VariantPlaylist getVariantPlaylist() {
            return this.variantPlaylist;
        }

        Playlist getCurrentPlaylist() {
            return this.currentPlaylist;
        }

        void setPlaylistURI(URI uRI) {
            this.playlistURI = uRI;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setReloadPlaylist(Playlist playlist) {
            Object object = this.reloadLock;
            synchronized (object) {
                this.reloadPlaylist = playlist;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setReloadAudioExtPlaylist(Playlist playlist) {
            Object object = this.reloadLock;
            synchronized (object) {
                this.reloadAudioExtPlaylist = playlist;
            }
        }

        @Override
        public void run() {
            while (!this.stopped) {
                try {
                    int n = this.stateQueue.take();
                    switch (n) {
                        case 0: {
                            this.stateInit();
                            break;
                        }
                        case 1: {
                            this.stopped = true;
                            break;
                        }
                        case 2: {
                            this.stateReloadPlaylist();
                            break;
                        }
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        void putState(int n) {
            if (this.stateQueue != null) {
                try {
                    this.stateQueue.put(n);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stateInit() {
            if (this.playlistURI == null) {
                return;
            }
            try {
                PlaylistParser playlistParser = new PlaylistParser();
                playlistParser.load(this.playlistURI);
                if (playlistParser.getVariantPlaylistOrNull() != null) {
                    this.variantPlaylist = playlistParser.getVariantPlaylistOrNull();
                } else if (this.currentPlaylist == null) {
                    this.currentPlaylist = playlistParser.getPlaylistOrNull();
                }
                if (this.variantPlaylist != null) {
                    long l;
                    boolean bl;
                    this.variantPlaylist.getExtStreamInf().forEach(extStreamInf -> {
                        Playlist playlist = new Playlist(extStreamInf.getPlaylistURI());
                        playlist.update(null);
                        playlist.setAudioGroupID(extStreamInf.getAudioGroupID());
                        extStreamInf.setPlaylist(playlist);
                    });
                    this.variantPlaylist.validateExtStreamInf();
                    this.currentPlaylist = this.variantPlaylist.getPlaylist(0);
                    if (this.currentPlaylist != null) {
                        bl = this.currentPlaylist.isFragmentedMP4();
                        l = bl ? this.currentPlaylist.getTargetDuration() : 0L;
                    } else {
                        bl = false;
                        l = 0L;
                    }
                    this.variantPlaylist.getAudioExtMedia().forEach(audioExtMedia -> {
                        Playlist playlist = new Playlist(audioExtMedia.getPlaylistURI());
                        playlist.setIsVideoStreamFragmentedMP4(bl);
                        playlist.setVideoStreamTargetDuration(l);
                        playlist.update(null);
                        audioExtMedia.setPlaylist(playlist);
                    });
                    this.variantPlaylist.validateAudioExtMedia();
                }
                if (this.variantPlaylist != null) {
                    this.currentPlaylist = this.variantPlaylist.getPlaylist(0);
                    if (this.currentPlaylist != null && this.currentPlaylist.isLive()) {
                        this.setReloadPlaylist(this.currentPlaylist);
                        Playlist playlist = this.variantPlaylist.getAudioExtPlaylist(this.currentPlaylist.getAudioGroupID());
                        if (playlist != null && playlist.isLive()) {
                            this.setReloadAudioExtPlaylist(playlist);
                        }
                        this.putState(2);
                    }
                }
            }
            finally {
                this.readySignal.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stateReloadPlaylist() {
            try {
                long l;
                Object object = this.reloadLock;
                synchronized (object) {
                    l = this.reloadPlaylist.getTargetDuration() / 2L;
                }
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            Object object = this.reloadLock;
            synchronized (object) {
                this.reloadPlaylist.update(null);
                if (this.reloadAudioExtPlaylist != null) {
                    this.reloadAudioExtPlaylist.update(null);
                }
            }
            this.putState(2);
        }
    }

    private static class AudioExtMedia {
        private String groupID = null;
        private String location = null;
        private URI playlistURI = null;
        private Playlist playlist = null;

        AudioExtMedia(String string, String string2) {
            this.groupID = string;
            this.location = string2;
        }

        String getGroupID() {
            return this.groupID;
        }

        String getLocation() {
            return this.location;
        }

        void setPlaylistURI(URI uRI) {
            this.playlistURI = uRI;
        }

        URI getPlaylistURI() {
            return this.playlistURI;
        }

        void setPlaylist(Playlist playlist) {
            this.playlist = playlist;
        }

        Playlist getPlaylist() {
            return this.playlist;
        }
    }

    private static class ExtStreamInf {
        private String location = null;
        private int bitrate = 0;
        private String audioGroupID = null;
        private URI playlistURI = null;
        private Playlist playlist = null;

        ExtStreamInf(String string, int n) {
            this.location = string;
            this.bitrate = n;
        }

        int getBitrate() {
            return this.bitrate;
        }

        void setAudioGroupID(String string) {
            this.audioGroupID = string;
        }

        String getAudioGroupID() {
            return this.audioGroupID;
        }

        String getLocation() {
            return this.location;
        }

        void setPlaylistURI(URI uRI) {
            this.playlistURI = uRI;
        }

        URI getPlaylistURI() {
            return this.playlistURI;
        }

        void setPlaylist(Playlist playlist) {
            this.playlist = playlist;
        }

        Playlist getPlaylist() {
            return this.playlist;
        }
    }

    private static class PlaylistParser {
        private URI playlistURI = null;
        private boolean isDiscontinuity = false;
        private VariantPlaylist variantPlaylist = null;
        private Playlist playlist = null;
        private boolean isEndList = false;
        private final String TAG_PARAM_TYPE = "TYPE";
        private final String TAG_PARAM_TYPE_AUDIO = "AUDIO";
        private final String TAG_PARAM_GROUP_ID = "GROUP-ID";
        private final String TAG_PARAM_AUTOSELECT = "AUTOSELECT";
        private final String TAG_PARAM_DEFAULT = "DEFAULT";
        private final String TAG_PARAM_URI = "URI";
        private final String TAG_PARAM_BANDWIDTH = "BANDWIDTH";
        private final String TAG_PARAM_AUDIO = "AUDIO";
        private final String TAG_VALUE_YES = "YES";

        private PlaylistParser() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void load(URI uRI) {
            this.playlistURI = uRI;
            HttpURLConnection httpURLConnection = null;
            BufferedReader bufferedReader = null;
            try {
                Charset charset;
                httpURLConnection = (HttpURLConnection)uRI.toURL().openConnection();
                httpURLConnection.setRequestMethod("GET");
                if (httpURLConnection.getResponseCode() != 200) {
                    MediaUtils.error(this, MediaError.ERROR_LOCATOR_CONNECTION_LOST.code(), "HTTP responce code: " + httpURLConnection.getResponseCode(), null);
                }
                if ((charset = this.getCharset(uRI.toURL().toExternalForm(), httpURLConnection.getContentType())) != null) {
                    bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), charset));
                }
                if (bufferedReader != null && "#EXTM3U".equals(bufferedReader.readLine())) {
                    this.parse(bufferedReader);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                    Locator.closeConnection(httpURLConnection);
                }
            }
        }

        private VariantPlaylist getVariantPlaylist() {
            if (this.variantPlaylist == null) {
                this.variantPlaylist = new VariantPlaylist(this.playlistURI);
            }
            return this.variantPlaylist;
        }

        VariantPlaylist getVariantPlaylistOrNull() {
            return this.variantPlaylist;
        }

        void setPlaylist(Playlist playlist) {
            this.playlist = playlist;
        }

        private Playlist getPlaylist() {
            if (this.playlist == null) {
                this.playlist = new Playlist(this.playlistURI);
            }
            return this.playlist;
        }

        Playlist getPlaylistOrNull() {
            return this.playlist;
        }

        boolean isLivePlaylist() {
            return !this.isEndList;
        }

        private void validateArray(String[] stringArray, int n) {
            if (stringArray.length < n) {
                throw new MediaException("Invalid HLS playlist");
            }
        }

        private String getNextLine(BufferedReader bufferedReader) throws IOException {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.isEmpty() || string.startsWith("#")) continue;
                return string;
            }
            throw new MediaException("Invalid HLS playlist");
        }

        private void parse(BufferedReader bufferedReader) throws IOException {
            String string;
            block20: while ((string = bufferedReader.readLine()) != null) {
                if (string.isEmpty() || string.startsWith("#") && !string.startsWith("#EXT")) continue;
                String[] stringArray = string.split(":");
                this.validateArray(stringArray, 1);
                switch (stringArray[0]) {
                    case "#EXTINF": {
                        this.validateArray(stringArray, 2);
                        String[] stringArray2 = stringArray[1].split(",");
                        this.validateArray(stringArray2, 1);
                        String string2 = this.getNextLine(bufferedReader);
                        this.getPlaylist().addMediaFile(string2, Double.parseDouble(stringArray2[0]), this.isDiscontinuity);
                        this.isDiscontinuity = false;
                        break;
                    }
                    case "#EXT-X-TARGETDURATION": {
                        this.validateArray(stringArray, 2);
                        this.getPlaylist().setTargetDuration(Integer.parseInt(stringArray[1]));
                        break;
                    }
                    case "#EXT-X-MEDIA-SEQUENCE": {
                        this.validateArray(stringArray, 2);
                        this.getPlaylist().setSequenceNumber(Integer.parseInt(stringArray[1]));
                        break;
                    }
                    case "#EXT-X-STREAM-INF": {
                        this.validateArray(stringArray, 2);
                        String[] stringArray2 = stringArray[1].split(",");
                        int n = this.getIntegerParams("BANDWIDTH", stringArray2);
                        String string3 = this.getStringParams("AUDIO", stringArray2);
                        String string4 = this.getNextLine(bufferedReader);
                        Object object = new ExtStreamInf(string4, n);
                        ((ExtStreamInf)object).setAudioGroupID(string3);
                        this.getVariantPlaylist().addExtStreamInf((ExtStreamInf)object);
                        break;
                    }
                    case "#EXT-X-ENDLIST": {
                        this.isEndList = true;
                        break;
                    }
                    case "#EXT-X-DISCONTINUITY": {
                        this.isDiscontinuity = true;
                        break;
                    }
                    case "#EXT-X-MAP": {
                        this.validateArray(stringArray, 2);
                        String[] stringArray2 = stringArray[1].split(",");
                        String string2 = this.getStringParams("URI", stringArray2);
                        this.getPlaylist().addMediaFile(string2, this.getPlaylist().getTargetDuration(), true);
                        break;
                    }
                    case "#EXT-X-MEDIA": {
                        this.validateArray(stringArray, 2);
                        String[] stringArray2 = stringArray[1].split(",");
                        String string2 = this.getStringParams("TYPE", stringArray2);
                        if (!string2.equals("AUDIO")) break;
                        String string3 = this.getStringParams("GROUP-ID", stringArray2);
                        String string4 = this.getStringParams("AUTOSELECT", stringArray2);
                        Object object = this.getStringParams("DEFAULT", stringArray2);
                        String string5 = this.getStringParams("URI", stringArray2);
                        boolean bl = "YES".equalsIgnoreCase(string4);
                        boolean bl2 = "YES".equalsIgnoreCase((String)object);
                        if (string5 == null || !bl && !bl2) continue block20;
                        AudioExtMedia audioExtMedia = new AudioExtMedia(string3, string5);
                        this.getVariantPlaylist().addAudioExtMedia(audioExtMedia);
                        break;
                    }
                }
            }
        }

        private String getStringParams(String string3, String[] stringArray) {
            Stream<String> stream = Arrays.stream(stringArray);
            return stream.filter(string2 -> string2.startsWith(string3)).flatMap(string -> {
                String string2 = string.trim();
                String[] stringArray = string2.split("=");
                if (stringArray.length == 2 && !stringArray[1].isEmpty()) {
                    return Stream.of(stringArray[1].replaceAll("^\"+|\"+$", ""));
                }
                return Stream.empty();
            }).findFirst().orElse(null);
        }

        private int getIntegerParams(String string3, String[] stringArray) {
            Stream<String> stream = Arrays.stream(stringArray);
            return stream.filter(string2 -> string2.startsWith(string3)).flatMap(string -> {
                String string2 = string.trim();
                String[] stringArray = string2.split("=");
                if (stringArray.length == 2 && !stringArray[1].isEmpty()) {
                    return Stream.of(Integer.valueOf(Integer.parseInt(stringArray[1])));
                }
                return Stream.empty();
            }).findFirst().orElse(null);
        }

        private Charset getCharset(String string, String string2) {
            if (string != null && HLSConnectionHolder.stripParameters(string).endsWith(".m3u8") || string2 != null && string2.equals("application/vnd.apple.mpegurl")) {
                if (Charset.isSupported(HLSConnectionHolder.CHARSET_UTF_8)) {
                    return Charset.forName(HLSConnectionHolder.CHARSET_UTF_8);
                }
            } else if ((string != null && HLSConnectionHolder.stripParameters(string).endsWith(".m3u") || string2 != null && string2.equals("audio/mpegurl")) && Charset.isSupported(HLSConnectionHolder.CHARSET_US_ASCII)) {
                return Charset.forName(HLSConnectionHolder.CHARSET_US_ASCII);
            }
            return null;
        }
    }
}

