/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import aQute.bnd.annotation.spi.ServiceProvider;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.factory.map.primitive.ImmutableShortObjectMapFactory;
import org.eclipse.collections.api.map.primitive.ImmutableShortObjectMap;
import org.eclipse.collections.api.map.primitive.MutableShortObjectMap;
import org.eclipse.collections.api.map.primitive.ShortObjectMap;
import org.eclipse.collections.impl.factory.primitive.ShortObjectMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableShortObjectEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableShortObjectHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableShortObjectSingletonMap;

@ServiceProvider(value=ImmutableShortObjectMapFactory.class)
public class ImmutableShortObjectMapFactoryImpl
implements ImmutableShortObjectMapFactory {
    public static final ImmutableShortObjectMapFactory INSTANCE = new ImmutableShortObjectMapFactoryImpl();

    @Override
    public <V> ImmutableShortObjectMap<V> empty() {
        return ImmutableShortObjectEmptyMap.INSTANCE;
    }

    @Override
    public <V> ImmutableShortObjectMap<V> of() {
        return this.empty();
    }

    @Override
    public <V> ImmutableShortObjectMap<V> with() {
        return this.empty();
    }

    @Override
    public <V> ImmutableShortObjectMap<V> of(short key, V value) {
        return this.with(key, value);
    }

    @Override
    public <V> ImmutableShortObjectMap<V> with(short key, V value) {
        return new ImmutableShortObjectSingletonMap<V>(key, value);
    }

    @Override
    public <V> ImmutableShortObjectMap<V> ofAll(ShortObjectMap<? extends V> map) {
        return this.withAll(map);
    }

    @Override
    public <V> ImmutableShortObjectMap<V> withAll(ShortObjectMap<? extends V> map) {
        if (map instanceof ImmutableShortObjectMap) {
            return (ImmutableShortObjectMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            short[] array = new short[1];
            map.forEachKey(each -> {
                array[0] = each;
            });
            return new ImmutableShortObjectSingletonMap<V>(array[0], map.get(array[0]));
        }
        return new ImmutableShortObjectHashMap<V>(map);
    }

    @Override
    public <T, V> ImmutableShortObjectMap<V> from(Iterable<T> iterable, ShortFunction<? super T> keyFunction, Function<? super T, ? extends V> valueFunction) {
        MutableShortObjectMap<V> map = ShortObjectMaps.mutable.from(iterable, keyFunction, valueFunction);
        return map.toImmutable();
    }
}

