/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable.primitive;

import aQute.bnd.annotation.spi.ServiceProvider;
import java.util.stream.IntStream;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.factory.stack.primitive.MutableIntStackFactory;
import org.eclipse.collections.api.stack.primitive.MutableIntStack;
import org.eclipse.collections.impl.factory.primitive.IntStacks;
import org.eclipse.collections.impl.stack.mutable.primitive.IntArrayStack;
import org.eclipse.collections.impl.utility.Iterate;

@ServiceProvider(value=MutableIntStackFactory.class)
public class MutableIntStackFactoryImpl
implements MutableIntStackFactory {
    public static final MutableIntStackFactory INSTANCE = new MutableIntStackFactoryImpl();

    @Override
    public MutableIntStack empty() {
        return new IntArrayStack();
    }

    @Override
    public MutableIntStack of() {
        return this.empty();
    }

    @Override
    public MutableIntStack with() {
        return this.empty();
    }

    @Override
    public MutableIntStack of(int ... items) {
        return this.with(items);
    }

    @Override
    public MutableIntStack with(int ... items) {
        if (items.length == 0) {
            return this.empty();
        }
        return IntArrayStack.newStackWith(items);
    }

    @Override
    public MutableIntStack ofAll(IntIterable items) {
        return this.withAll(items);
    }

    @Override
    public MutableIntStack withAll(IntIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return IntArrayStack.newStack(items);
    }

    @Override
    public MutableIntStack ofAll(Iterable<Integer> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public MutableIntStack withAll(Iterable<Integer> iterable) {
        MutableIntStack stack = IntStacks.mutable.empty();
        Iterate.forEach(iterable, stack::push);
        return stack;
    }

    @Override
    public MutableIntStack ofAllReversed(IntIterable items) {
        return this.withAllReversed(items);
    }

    @Override
    public MutableIntStack withAllReversed(IntIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return IntArrayStack.newStackFromTopToBottom(items);
    }

    @Override
    public MutableIntStack ofAll(IntStream items) {
        return this.withAll(items);
    }

    @Override
    public MutableIntStack withAll(IntStream items) {
        return this.with(items.toArray());
    }
}

