/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.turbo;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.turbo.LRUMessageCache;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Marker;

public class PackagesAwareDuplicateMessageFilter
extends TurboFilter {
    public static final int DEFAULT_CACHE_SIZE = 100;
    public static final int DEFAULT_ALLOWED_REPETITIONS = 5;
    public static final int DEFAULT_CACHE_TTL_MINUTES = 60;
    private static final String ASTERISK = "*";
    protected final Map<String, Boolean> duplicateMessagesFilterableCache = Maps.newHashMap();
    protected final List<String> filterablePackages = new ArrayList<String>();
    protected LRUMessageCache msgCache;
    protected int allowedRepetitions = 5;
    protected int cacheSize = 100;
    protected int cacheTtlMinutes = 60;
    protected DateTime lastCacheClear;

    @Override
    public void start() {
        this.lastCacheClear = DateTime.now();
        this.msgCache = new LRUMessageCache(this.cacheSize);
        super.start();
    }

    @Override
    public void stop() {
        this.msgCache.clear();
        this.msgCache = null;
        super.stop();
    }

    @Override
    public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
        String loggerName = logger.getName();
        if (this.isDuplicateMessagesFilterable(loggerName)) {
            return this.filterDecide(marker, logger, level, format, params, t);
        }
        return FilterReply.NEUTRAL;
    }

    protected FilterReply filterDecide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
        this.checkCacheClear();
        int count = this.msgCache.getMessageCountAndThenIncrement(format);
        if (count < this.allowedRepetitions) {
            return FilterReply.NEUTRAL;
        }
        return FilterReply.DENY;
    }

    private void checkCacheClear() {
        if (this.cacheTtlMinutes <= 0) {
            return;
        }
        if (this.lastCacheClear.plusMinutes(this.cacheTtlMinutes).isBeforeNow()) {
            this.clearCache();
        }
    }

    public void clearCache() {
        this.lastCacheClear = DateTime.now();
        this.msgCache.clear();
    }

    private synchronized boolean isDuplicateMessagesFilterable(String loggerNameToCheck) {
        return this.duplicateMessagesFilterableCache.computeIfAbsent(loggerNameToCheck, this::checkIfLoggerNameIsIncludedInFilterable);
    }

    private boolean checkIfLoggerNameIsIncludedInFilterable(String loggerName) {
        return this.filterablePackages.stream().filter(Objects::nonNull).anyMatch(filterPattern -> {
            boolean wildcard = filterPattern.endsWith(ASTERISK);
            if (wildcard) {
                return loggerName.startsWith(StringUtils.removeEnd(filterPattern, ASTERISK));
            }
            return StringUtils.equals(loggerName, filterPattern);
        });
    }

    public void setFilterable(String filterable) {
        this.filterablePackages.add(filterable);
    }

    public int getAllowedRepetitions() {
        return this.allowedRepetitions;
    }

    public void setAllowedRepetitions(int allowedRepetitions) {
        this.allowedRepetitions = allowedRepetitions;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public int getCacheTtlMinutes() {
        return this.cacheTtlMinutes;
    }

    public void setCacheTtlMinutes(int cacheTtlMinutes) {
        this.cacheTtlMinutes = cacheTtlMinutes;
    }
}

