/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.comxerv.common;

import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.AbstractComXervAmqpBackend;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.AbstractComXervAmqpBackendFactory;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationUI;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.core.entity.SystemInfo;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.entities.H2HArea;
import com.deutscheboerse.comxerv.comtrader.entities.HubToHub;
import com.deutscheboerse.comxerv.comtrader.entities.MarketArea;
import com.deutscheboerse.comxerv.comtrader.entities.MarketState;
import com.deutscheboerse.comxerv.comtrader.entities.Member;
import com.deutscheboerse.comxerv.comtrader.entities.Message;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.OrderLimit;
import com.deutscheboerse.comxerv.comtrader.entities.OwnUser;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.PublicTradeConfirmation;
import com.deutscheboerse.comxerv.comtrader.entities.RiskSet;
import com.deutscheboerse.comxerv.comtrader.entities.TradeSettlement;
import com.deutscheboerse.comxerv.comtrader.entities.TradingLimit;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.session.ConnectionParameters;
import com.deutscheboerse.comxerv.comtrader.entities.session.ConnectionParametersWithFallback;
import com.deutscheboerse.comxerv.comtrader.entities.session.LogoutNotification;
import com.deutscheboerse.comxerv.comtrader.entities.session.LogoutType;
import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.entities.type.MessageSeverity;
import com.deutscheboerse.comxerv.comtrader.entities.type.SpecialMessage;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.BroadcastListenerHandlerForClass;
import com.deutscheboerse.comxerv.comtrader.service.LoginException;
import com.deutscheboerse.comxerv.comtrader.service.MessagePublisher;
import com.deutscheboerse.comxerv.comtrader.service.amqp.AbstractAmqpBackend;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ErrorHandler;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ExchangeConnection;
import com.deutscheboerse.comxerv.comtrader.service.amqp.MarshallerException;
import com.deutscheboerse.comxerv.comtrader.service.amqp.MessageInterceptor;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ObjectHandler;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ResponseWithCorrelationId;
import com.deutscheboerse.comxerv.comtrader.service.amqp.SimpleResponseWithCorrelationId;
import com.deutscheboerse.comxerv.comtrader.service.amqp.UiThreadObjectHandler;
import com.deutscheboerse.comxerv.comtrader.service.event.LogoutCleanUpDataModelEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.PreUserDataResetEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.UserDataResetEvent;
import com.deutscheboerse.comxerv.comtrader.service.info.InfoLogger;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.m7.trading.api.Request;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.google.common.base.Strings;
import com.google.common.eventbus.EventBus;
import com.rabbitmq.client.Address;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXParseException;

public abstract class AbstractComXervExchangeConnection
implements ExchangeConnection {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractComXervExchangeConnection.class);
    private final TimeService timeService;
    private final UiThreadObjectHandler uiThreadObjectHandler;
    private final List<MessageInterceptor> messageInterceptors;
    private volatile AtomicReference<ConnectionState> connectionState = new AtomicReference<ConnectionState>(ConnectionState.CONNECTED);
    private final ScheduledExecutorService scheduledExecutorService;
    protected final MapperHandler mappers;
    protected final BroadcastListenerHandlerForClass broadcastHandler;
    protected final ApplicationContext appContext;
    private final ConnectionParametersWithFallback connectionParameters;
    private final ApplicationUI applicationUI;
    private final ObservableValue<User> currentUser;
    private final AtomicReference<AbstractComXervAmqpBackend> amqpBackend;
    private volatile Session session;
    protected AtomicLong eventIndex = new AtomicLong(0L);
    private final ChangeListener<User> userChangeListener;

    protected AbstractComXervExchangeConnection(ApplicationContext applicationContext, ConnectionParametersWithFallback connectionParameters) {
        this.appContext = applicationContext;
        this.connectionParameters = connectionParameters;
        this.timeService = applicationContext.getService(TimeService.class);
        this.uiThreadObjectHandler = applicationContext.getService(UiThreadObjectHandler.class);
        this.messageInterceptors = new CopyOnWriteArrayList<MessageInterceptor>();
        this.amqpBackend = new AtomicReference();
        this.applicationUI = applicationContext.getService(ApplicationUI.class);
        this.scheduledExecutorService = applicationContext.getService(ScheduledExecutorService.class, WorkerExecutor.class);
        this.broadcastHandler = applicationContext.getService(BroadcastListenerHandlerForClass.class);
        this.mappers = new MapperHandler();
        this.currentUser = applicationContext.getService(UserService.class).currentUserProperty();
        this.userChangeListener = (observable2, oldValue, newValue) -> this.currentUserChanged((User)newValue);
    }

    protected void registerCommonHandlers(AbstractAmqpBackend amqpBackend) {
        amqpBackend.addErrorHandler(new ErrorHandler(){

            @Override
            public void handleException(Session session, Exception e) {
                AbstractComXervExchangeConnection.this.publishMessage(e);
            }

            @Override
            public void handleGapDetected(Session session, String description) {
                AbstractComXervExchangeConnection.this.forceLogoutAndOfferRelogin(description);
            }

            @Override
            public void handleConnectionError(Session session, String description) {
                AbstractComXervExchangeConnection.this.appContext.getService(InfoLogger.class).probeInternetConnectivity();
                AbstractComXervExchangeConnection.this.localLogout();
                AbstractComXervExchangeConnection.this.notifyLogout(description);
            }

            @Override
            public void handleUserChangeException(Session session, ErrorHandler.UserChangeType type) {
                LogoutType logoutType = null;
                switch (type) {
                    case SUSPENSION: {
                        logoutType = LogoutType.EXTERNAL_SUSPENDED;
                        break;
                    }
                    case DELETION: {
                        logoutType = LogoutType.EXTERNAL_DELETED;
                        break;
                    }
                    case PASSWORD_RESET: {
                        logoutType = LogoutType.EXTERNAL_PASSWORD_RESET;
                        break;
                    }
                    case PASSWORD_CHANGE: {
                        logoutType = LogoutType.EXTERNAL_PASSWORD_CHANGE;
                        break;
                    }
                    case PASSWORD_CHANGE_ERROR: {
                        logoutType = LogoutType.EXTERNAL_PASSWORD_CHANGE_ERROR;
                        break;
                    }
                    case ACCOUNT_CHANGE: {
                        logoutType = LogoutType.EXTERNAL_ACCOUNT_CHANGE;
                        break;
                    }
                    case ADMIN_MODIFICATION: {
                        logoutType = LogoutType.EXTERNAL_ADMIN_MODIFICATION;
                        break;
                    }
                    case CONNECTION_TERMINATED_BY_CORE: {
                        logoutType = LogoutType.EXTERNAL_TERMINATED_BY_CORE;
                        break;
                    }
                    default: {
                        LOG.error("Unhandleded type {}", (Object)type);
                    }
                }
                AbstractComXervExchangeConnection.this.getBroadcastHandler().notifyListeners(new LogoutNotification(AbstractComXervExchangeConnection.this.sessionRemoteId(session), "", logoutType));
            }
        });
        amqpBackend.addMessageInterceptor((session1, messageBytes, timestamp, outgoing, routingKey, correlationId, eventIndex1) -> {
            for (MessageInterceptor messageInterceptor : this.messageInterceptors) {
                try {
                    messageBytes = messageInterceptor.handleMessage(session1, messageBytes, timestamp, outgoing, routingKey, correlationId, eventIndex1);
                }
                catch (Exception e) {
                    LOG.error("Interceptor " + String.valueOf(messageInterceptor) + " threw an exception", e);
                }
            }
            return messageBytes;
        });
    }

    private Long sessionRemoteId(Session session) {
        return session != null ? session.getRemoteId() : null;
    }

    @Override
    public void addObjectHandler(ObjectHandler<Object> objectHandler) {
        this.uiThreadObjectHandler.addObjectHandler(objectHandler);
    }

    @Override
    public void removeObjectHandler(ObjectHandler<Object> objectHandler) {
        this.uiThreadObjectHandler.removeObjectHandler(objectHandler);
    }

    @Override
    public void addMessageInterceptor(MessageInterceptor messageInterceptor) {
        this.messageInterceptors.add(messageInterceptor);
    }

    protected boolean isConnected() {
        return this.connectionState.get() == ConnectionState.CONNECTED;
    }

    protected void disconnecting() {
        this.connectionState.set(ConnectionState.DISCONNECTING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResponseWithCorrelationId sendRequestAndReturnException(Request request, boolean handleErrResp) {
        final AtomicReference<Object> eRef = new AtomicReference<Object>(null);
        ErrorHandler errorHandler = new ErrorHandler(){

            @Override
            public void handleException(Session session, Exception e) {
                eRef.set(e);
            }

            @Override
            public void handleGapDetected(Session session, String description) {
            }

            @Override
            public void handleConnectionError(Session session, String description) {
            }

            @Override
            public void handleUserChangeException(Session session, ErrorHandler.UserChangeType type) {
            }
        };
        this.getAmqpBackend().addErrorHandler(errorHandler);
        try {
            ResponseWithCorrelationId result = this.sendRequest(request, handleErrResp, 60000);
            if ((result == null || result.getResponse() == null) && eRef.get() != null) {
                SimpleResponseWithCorrelationId simpleResponseWithCorrelationId = new SimpleResponseWithCorrelationId(eRef.get(), null);
                return simpleResponseWithCorrelationId;
            }
            ResponseWithCorrelationId responseWithCorrelationId = result;
            return responseWithCorrelationId;
        }
        finally {
            this.getAmqpBackend().removeErrorHandler(errorHandler);
        }
    }

    public void forceLogoutAndOfferRelogin(String errorDetails) {
        try {
            this.logout();
        }
        catch (Exception e) {
            LOG.error("Forced logout error", e);
        }
        finally {
            this.notifyLogout(errorDetails);
        }
    }

    private void notifyLogout(String errorDetails) {
        try {
            LogoutNotification notification = new LogoutNotification(this.sessionRemoteId(this.session), errorDetails, LogoutType.CONNECTION_FAILED);
            this.getBroadcastHandler().notifyListeners(notification);
        }
        catch (Exception e) {
            LOG.error("Forced logout error", e);
        }
    }

    protected void publishMessage(Exception e) {
        this.publishMessage(MessageSeverity.ERROR, this.getMessage(e));
    }

    private String getMessage(Exception e) {
        if (e.getCause() instanceof SAXParseException) {
            e = (Exception)e.getCause();
        } else if (e instanceof MarshallerException) {
            MarshallerException marshallerException = (MarshallerException)e;
            String msgType = this.getMessageTypeFromException(marshallerException);
            if (msgType == null) {
                return Util.getLabel("commons_cannotProcessMessageUnknownType", e.getCause().getClass().getName());
            }
            return Util.getLabel("commons_cannotProcessMessageKnownType", msgType, e.getCause().getClass().getName());
        }
        String message = e.getMessage();
        if (message == null || message.trim().isEmpty()) {
            message = Util.getLabel("commons_cannotProcessMessageUnknownType", e.getClass().getSimpleName());
        }
        return message;
    }

    private String getMessageTypeFromException(MarshallerException e) {
        String msgType = null;
        String message = e.getMessageContent();
        try {
            if (!Strings.isNullOrEmpty(message)) {
                message = message.substring(0, message.indexOf("xmlns"));
                msgType = message = message.substring(message.lastIndexOf(60) + 1).trim();
            }
        }
        catch (Exception ex) {
            LOG.error("Error while retrieving message type from xml", ex);
        }
        return msgType;
    }

    protected void publishMessage(MessageSeverity severity, String errorText) {
        this.publishMessage(severity, errorText, null);
    }

    protected void publishMessage(MessageSeverity severity, String errorText, SpecialMessage specialMessage) {
        this.publishMessage(Message.createClientMessage(this.getExchange(), this.timeService.getLocalTime(), errorText, severity, specialMessage));
    }

    protected void publishMessage(Message message) {
        FxUtil.runInFxThread(() -> this.getBroadcastHandler().notifyListeners(message));
    }

    @Override
    public void connect() throws LoginException {
        List<ConnectionParameters> allParams = this.connectionParameters.getConnectionParameters().stream().filter(cp -> cp.getLeasedLine() == this.connectionParameters.getUseLeasedLine()).toList();
        List<Address> addresses = allParams.stream().map(p -> new Address(p.getRabbitHost(), p.getRabbitPort())).toList();
        for (int i = 0; i < allParams.size(); ++i) {
            ConnectionParameters candidate = allParams.get(i);
            candidate.setAddresses(addresses);
            try {
                this.appContext.getService(InfoLogger.class).logConnectivityTest();
                this.createConnection(candidate);
                return;
            }
            catch (LoginException e) {
                if (e.getErrorType() == LoginException.ErrorType.INFRASTRUCTURE_ERROR) {
                    if (i == allParams.size() - 1) {
                        throw e;
                    }
                } else {
                    throw e;
                }
                LOG.info("Connection to " + String.valueOf(candidate) + " failed. Backup connection will be tried.", e);
                this.disconnectAmqpBackend();
                continue;
            }
        }
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public Exchange getExchange() {
        return this.connectionParameters.getExchange();
    }

    @Override
    public ConnectionParametersWithFallback getConnectionParameters() {
        return this.connectionParameters;
    }

    private synchronized void createConnection(ConnectionParameters params) throws LoginException {
        LOG.info("attempting to createConnection to: {}", (Object)params);
        Exchange exchange = Exchange.get(params.getExchangeId());
        this.session = new Session(params, exchange, this.timeService.getLocalTime());
        this.currentUser.addListener(this.userChangeListener);
        AbstractComXervAmqpBackend newBackend = this.appContext.getService(AbstractComXervAmqpBackendFactory.class, exchange).createComXervAmqpBackend(this.session);
        this.disconnectAmqpBackend(this.amqpBackend.getAndSet(newBackend));
        this.registerCommonHandlers(newBackend);
        newBackend.connect();
    }

    @Override
    public synchronized void disconnect() {
        this.connectionState.set(ConnectionState.DISCONNECTED);
        this.disconnectAmqpBackend();
        this.session = null;
        this.currentUser.removeListener(this.userChangeListener);
    }

    private void disconnectAmqpBackend() {
        this.disconnectAmqpBackend(this.amqpBackend.getAndSet(null));
    }

    private void disconnectAmqpBackend(AbstractComXervAmqpBackend abstractComXervAmqpBackend) {
        try {
            Optional.ofNullable(abstractComXervAmqpBackend).ifPresent(AbstractComXervAmqpBackend::disconnect);
        }
        catch (Exception e) {
            LOG.error("Could not disconnect.", e);
        }
    }

    private void currentUserChanged(User newValue) {
        if (newValue != null && !(newValue instanceof OwnUser) && newValue.getExchange().getSystemInfo().supportsTradingLimit()) {
            this.scheduledExecutorService.execute(() -> {
                List<? extends BroadcastEntity<String>> limits = this.getTradingLimit(newValue.getMemberId());
                FxUtil.runInFxThread(() -> limits.forEach(this.broadcastHandler::notifyListeners));
            });
        }
    }

    public void forceFullDataReload() {
        LOG.info("Force data reload.");
        EventBus eventBus = this.appContext.getService(EventBus.class);
        User ownUser = this.getOwnUser();
        eventBus.post(new PreUserDataResetEvent(this.session));
        eventBus.post(new LogoutCleanUpDataModelEvent(this.session));
        this.applicationUI.requestCompleteUiRefresh();
        this.appContext.getDataModel(User.class).handleBroadcastEntity(ownUser);
        this.getAmqpBackend().resetGapDetection();
        eventBus.post(new UserDataResetEvent(this.session));
        this.appContext.getService(MessagePublisher.class).publishMessage(Util.getLabel("comxervExchangeConnection_force_refresh"), MessageSeverity.HIGH);
    }

    protected User getOwnUser() {
        return this.appContext.getService(UserService.class).getOwnUser();
    }

    @Override
    public MapperHandler getMapper() {
        return this.mappers;
    }

    @Override
    public ResponseWithCorrelationId sendRequest(byte[] message, String routingKey, int timeout, boolean retry, boolean handleErrResp, boolean compress, Long userInputtedEventIndex) {
        return this.getAmqpBackend().sendRequest(message, routingKey, timeout, retry, handleErrResp, compress, this.useCorrectEventIndex(userInputtedEventIndex));
    }

    @Override
    public ResponseWithCorrelationId sendRequest(Request request, boolean handleErrResp, String correlationId) {
        return this.getAmqpBackend().sendRequest(request, handleErrResp, 10000, correlationId, this.eventIndex);
    }

    @Override
    public ResponseWithCorrelationId sendRequest(Request request, boolean handleErrResp, int timeout) {
        return this.getAmqpBackend().sendRequest(request, handleErrResp, timeout, null, this.eventIndex);
    }

    protected ResponseWithCorrelationId sendRequest(Request request) {
        return this.sendRequest(request, true, 60000);
    }

    @Override
    public void startBroadcastListener() {
        this.getAmqpBackend().startBroadcastListener();
    }

    @Override
    public void processBroadcastListener() {
        this.getAmqpBackend().processBroadcastListener();
    }

    public BroadcastListenerHandlerForClass getBroadcastHandler() {
        return this.broadcastHandler;
    }

    protected AbstractAmqpBackend getAmqpBackend() {
        return this.amqpBackend.get();
    }

    public abstract int getLoggedInUserId();

    public abstract List<? extends BroadcastEntity<String>> getTradingLimit(String var1);

    public abstract List<? extends BroadcastEntity<String>> getTradingLimit();

    public abstract Set<TradingLimit> getCommodityLimits();

    public abstract Set<OrderLimit> getOrderLimits(Set<String> var1);

    public abstract MarketState getMarketState();

    public abstract SystemInfo getSystemInfo();

    public abstract Set<Message> getMessages(String var1, DateTime var2, DateTime var3);

    public abstract Set<Product> getProducts();

    public abstract Set<MarketArea> getMarketAreas();

    public abstract Set<H2HArea> getH2HAreas();

    public abstract Set<DeliveryArea> getDeliveryAreas();

    public abstract Set<Orderbook> getOrderbooks(DeliveryArea var1, Set<String> var2);

    public abstract Set<PublicTradeConfirmation> getPublicTradeConfirmation(DateTime var1, DateTime var2);

    public abstract Set<HubToHub> getHubToHub(LocalDate var1);

    public abstract Set<Order> getOwnAndPreArrangedOrders();

    public abstract Set<FullTrade> getTrades(Set<BalancingGroup> var1, DateTime var2, DateTime var3);

    public abstract List<TradeSettlement> getTradeSettlementInfo(DateTime var1, DateTime var2);

    public abstract Set<Member> getAllMembers();

    public abstract Set<BalancingGroup> getBalancingGroups();

    public abstract Set<User> getAllUsers();

    public abstract Set<User> getUsersForMembers(Set<String> var1);

    public abstract Set<RiskSet> getRiskSets();

    private AtomicLong useCorrectEventIndex(Long userInputtedEventIndex) {
        if (userInputtedEventIndex == null) {
            return this.eventIndex;
        }
        if (userInputtedEventIndex < 0L) {
            return null;
        }
        return new AtomicLong(userInputtedEventIndex);
    }

    private static enum ConnectionState {
        CONNECTED,
        DISCONNECTING,
        DISCONNECTED;

    }
}

