/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.comxerv.common;

import com.deutscheboerse.comxerv.comtrader.service.amqp.MarshallerException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ComXervMarshaller
implements com.deutscheboerse.comxerv.comtrader.service.amqp.Marshaller {
    private static final Logger LOG = LoggerFactory.getLogger(ComXervMarshaller.class);
    private final String contentType;
    private JAXBContext jaxbContext;
    private Schema schema;
    private ThreadLocal<XMLInputFactory> xmlInputFactory = ThreadLocal.withInitial(this::newXmlInputFactory);

    public ComXervMarshaller(String schemaRootVersion, String contentTypeVersion, String contentTypePrimary, String packageName, String urlSchema) {
        this.contentType = this.createContentType(contentTypeVersion, contentTypePrimary);
        this.init(schemaRootVersion, packageName, urlSchema);
    }

    private String createContentType(String contentTypeVersion, String contentTypePrimary) {
        return ContentType.create(contentTypePrimary + "/request", new BasicNameValuePair("version", contentTypeVersion)).toString();
    }

    private URL createSchemaUrl(String schemaRootVersion, String urlSchemaName) {
        String urlString = "/v" + schemaRootVersion + "/" + urlSchemaName + ".xsd";
        return this.getClass().getResource(urlString);
    }

    private void init(String schemaRootVersion, String packageName, String urlSchema) {
        String basePackageName = packageName + schemaRootVersion;
        URL schemaURL = this.createSchemaUrl(schemaRootVersion, urlSchema);
        try {
            this.schema = this.loadSchema(schemaURL);
            this.jaxbContext = JAXBContext.newInstance(basePackageName);
        }
        catch (FileNotFoundException | JAXBException | SAXException e) {
            LOG.error("Failed to create JAXBContext", e);
        }
    }

    private Schema loadSchema(URL schemaUrl) throws FileNotFoundException, SAXException {
        if (schemaUrl == null) {
            throw new FileNotFoundException("Could not find XSD");
        }
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        sf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        return sf.newSchema(schemaUrl);
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public Object getObject(byte[] body) throws MarshallerException {
        try {
            return this.getObject(new ByteArrayInputStream(body));
        }
        catch (JAXBException | XMLStreamException e) {
            String message = new String(body);
            LOG.error(message);
            throw new MarshallerException(e, message);
        }
    }

    private Object getObject(InputStream is) throws JAXBException, XMLStreamException {
        Unmarshaller unmarshaller = this.createUnmarshaller();
        XMLStreamReader xsr = this.xmlInputFactory.get().createXMLStreamReader(new StreamSource(is));
        return unmarshaller.unmarshal(xsr);
    }

    private XMLInputFactory newXmlInputFactory() {
        XMLInputFactory xif = XMLInputFactory.newFactory();
        xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xif.setProperty("javax.xml.stream.supportDTD", false);
        return xif;
    }

    private Unmarshaller createUnmarshaller() throws JAXBException {
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        if (this.schema != null) {
            unmarshaller.setSchema(this.schema);
        }
        return unmarshaller;
    }

    @Override
    public byte[] getXmlBytes(Object jaxbSource) throws MarshallerException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.writeXmlBytes(bos, jaxbSource);
            return bos.toByteArray();
        }
        catch (JAXBException e) {
            throw new MarshallerException(e, null);
        }
    }

    private void writeXmlBytes(OutputStream os, Object jaxbSource) throws JAXBException {
        Marshaller marshaller = this.createMarshaller();
        marshaller.marshal(jaxbSource, os);
    }

    private Marshaller createMarshaller() throws JAXBException {
        Marshaller marshaller = this.jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.encoding", "UTF-8");
        return marshaller;
    }
}

