/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load;

import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.ComXervLoadContext;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadTask;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.util.concurrent.ConditionRunnable;
import java.util.Collections;
import java.util.Set;

public abstract class LoadSingleEntityTypeTask<T extends BroadcastEntity>
extends LoadTask
implements ConditionRunnable {
    private final Class<T> entityClass;
    private final boolean fireLoadingEvents;

    public LoadSingleEntityTypeTask(ComXervLoadContext loadContext, Class<T> entityClass) {
        this(loadContext, entityClass, true);
    }

    public LoadSingleEntityTypeTask(ComXervLoadContext loadContext, Class<T> entityClass, boolean fireLoadingEvents) {
        super(loadContext);
        this.entityClass = entityClass;
        this.fireLoadingEvents = fireLoadingEvents;
    }

    @Override
    public void run() {
        Set entities = Collections.emptySet();
        try {
            if (this.fireLoadingEvents) {
                this.getLoadContext().loadingStarted(this.entityClass);
            }
            entities = this.load();
        }
        catch (RuntimeException e) {
            this.getLoadContext().loadingError(e, this.entityClass);
        }
        finally {
            this.getLoadContext().handleEntities(this.entityClass, entities, this.fireLoadingEvents);
        }
    }

    protected abstract Set<T> load();
}

