/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6;

import com.deutscheboerse.comxerv.comtrader.api.m7.v6.AbstractComXervService;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.EnumMapper;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.ExchangeSpecific;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.entities.BespokeContract;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.Trade;
import com.deutscheboerse.comxerv.comtrader.service.async.AsyncResponse;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandler;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseStatus;
import com.deutscheboerse.comxerv.comtrader.service.trade.BespokeSubmitter;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.m7.trading.api.Request;
import com.deutscheboerse.m7.trading.api.v6.BespokeContractReq;
import com.deutscheboerse.m7.trading.api.v6.ContractInfoRprt;
import com.deutscheboerse.m7.trading.api.v6.ErrResp;
import com.deutscheboerse.m7.trading.api.v6.OrdrType;
import com.deutscheboerse.m7.trading.api.v6.PrearrangedOrdrEntryType;
import com.deutscheboerse.m7.trading.api.v6.PrearrangedTradeEntry;
import com.deutscheboerse.m7.trading.api.v6.StandardHeaderType;
import com.deutscheboerse.m7.trading.api.v6.TradeCaptureRprt;
import com.deutscheboerse.m7.trading.api.v6.TradeListEntryType;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@ExchangeSpecific(apiVersion="v6")
public class ComXervBespokeSubmitter
extends AbstractComXervService
implements BespokeSubmitter {
    private static final Logger LOG = LoggerFactory.getLogger(ComXervBespokeSubmitter.class);
    private final SmallFastDataModel<Long, Contract> contractDataModel;

    @Inject
    public ComXervBespokeSubmitter(ApplicationContext applicationContext) {
        super(applicationContext);
        this.contractDataModel = applicationContext.getSmallDataModel(Contract.class);
    }

    @Override
    public boolean processAsyncServerResponseForContractRequest(Object response, @Nonnull ResponseHandler responseHandler, @Nonnull BespokeSubmitter.AfterSuccessfullContractCreationHandler afterSuccessfullContractCreationHandler) {
        if (response instanceof ErrResp) {
            ErrResp errResp = (ErrResp)response;
            this.handleErrors(errResp.getError().stream(), responseHandler);
            return true;
        }
        if (response instanceof ContractInfoRprt) {
            Contract contract;
            List<Contract> receivedContracts;
            ContractInfoRprt contractInfoRprt = (ContractInfoRprt)response;
            responseHandler.handleResponse(new AsyncResponse(ResponseStatus.SUCCESS, null));
            ContractInfoRprt.ContractList contractList = contractInfoRprt.getContractList();
            if (contractList != null && (receivedContracts = this.getMapper().translateList(Contract.class, contractList.getContract())).size() == 1 && (contract = receivedContracts.get(0)) instanceof BespokeContract) {
                BespokeContract bespokeContract = (BespokeContract)contract;
                afterSuccessfullContractCreationHandler.handle(bespokeContract);
                return true;
            }
            throw new IllegalStateException("Received invalid bespoke contracts");
        }
        return false;
    }

    @Override
    public boolean processAsyncServerResponseForTradeRequest(Object response, ResponseHandler responseHandler) {
        if (response instanceof ErrResp) {
            ErrResp errResp = (ErrResp)response;
            this.handleErrors(errResp.getError().stream(), responseHandler);
            return true;
        }
        if (response instanceof TradeCaptureRprt) {
            TradeCaptureRprt tradeCaptureRprt = (TradeCaptureRprt)response;
            TradeListEntryType tradeListEntryType = tradeCaptureRprt.getTradeList().getTrade().get(0);
            Contract contract = (Contract)this.contractDataModel.findById(tradeListEntryType.getContractId());
            if (contract != null) {
                Product product = contract.getProduct();
                String messageText = Util.getLabel("bespokeTradesPanel_success_message", contract.getName(), product.mapQuantityFromBackend(tradeListEntryType.getQty()), product.getQuantityUnit(), product.mapPriceFromBackend(tradeListEntryType.getPx()));
                responseHandler.handleResponse(new AsyncResponse(ResponseStatus.SUCCESS, null, messageText, null));
            } else {
                String errorText = Util.getLabel("bespokeTradesPanel_error_contractNotFound", tradeListEntryType.getContractId());
                responseHandler.handleGeneralError(errorText);
                LOG.error("Contract not found");
            }
            return true;
        }
        return false;
    }

    @Override
    public Request createBespokeContractRequest(BespokeContract bespokeContract) {
        BespokeContractReq request = new BespokeContractReq();
        StandardHeaderType standardHeader = this.getStandardHeader(false);
        request.setStandardHeader(standardHeader);
        request.setName(bespokeContract.getName());
        BespokeContractReq.UndrlngContracts undrlngContracts = new BespokeContractReq.UndrlngContracts();
        bespokeContract.getUnderlyingContracts().stream().map(BroadcastEntity::getId).forEach(undrlngContracts.getContractId()::add);
        request.setUndrlngContracts(undrlngContracts);
        if (bespokeContract.isOption()) {
            request.setStrikePx(bespokeContract.getStrikePrc().getValue());
            request.setCallPut(EnumMapper.mapPutOrCall(bespokeContract.getPutOrCall()));
        }
        return request;
    }

    @Override
    public Request createBespokeTradeRequest(FullTrade trade, boolean pncTrade) {
        PrearrangedTradeEntry request = new PrearrangedTradeEntry();
        StandardHeaderType standardHeader = this.getStandardHeader(false);
        request.setStandardHeader(standardHeader);
        if (pncTrade) {
            request.setType(OrdrType.N);
        } else {
            request.setType(OrdrType.E);
        }
        Product product = trade.getContract().getProduct();
        request.setQty(product.mapQuantityToBackend(trade.getQuantity()));
        request.setPx(product.mapPriceToBackend(trade.getPrice()));
        request.setContractId((Long)trade.getContract().getId());
        request.setTxt(trade.getBuyOrder().getText());
        PrearrangedOrdrEntryType buySide = this.getPrearrangedOrdrEntryType(trade.getBuyOrder());
        request.setBuy(buySide);
        PrearrangedOrdrEntryType sellSide = this.getPrearrangedOrdrEntryType(trade.getSellOrder());
        request.setSell(sellSide);
        return request;
    }

    private PrearrangedOrdrEntryType getPrearrangedOrdrEntryType(Trade.OrderInfo orderInfo) {
        PrearrangedOrdrEntryType ordrEntryType = new PrearrangedOrdrEntryType();
        ordrEntryType.setAcctId(orderInfo.getBalancingGroupId());
        ordrEntryType.setDlvryAreaId(orderInfo.getDeliveryAreaId());
        ordrEntryType.setBrokerUserId((Integer)orderInfo.getBrokerUser().getId());
        ordrEntryType.setTraderUserId((Integer)orderInfo.getUser().getId());
        if (orderInfo.getOpenOrClose() != null) {
            ordrEntryType.setOpenCloseInd(EnumMapper.mapOpenOrClose(orderInfo.getOpenOrClose()));
        }
        ordrEntryType.setClearingAcctType(orderInfo.getAccount());
        return ordrEntryType;
    }
}

