/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper;

import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.EnumMapper;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.domain.query.ContractQueries;
import com.deutscheboerse.comxerv.comtrader.entities.BespokeContract;
import com.deutscheboerse.comxerv.comtrader.entities.BlockContract;
import com.deutscheboerse.comxerv.comtrader.entities.CompoundStatus;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractPhase;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractStatus;
import com.deutscheboerse.comxerv.comtrader.entities.type.ProductType;
import com.deutscheboerse.comxerv.comtrader.entities.type.PutOrCall;
import com.deutscheboerse.comxerv.comtrader.service.mapper.AbstractMapper;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.comxerv.comtrader.util.DateTimeUtils;
import com.deutscheboerse.m7.trading.api.v6.CallPutContractType;
import com.deutscheboerse.m7.trading.api.v6.ContractListEntryType;
import com.deutscheboerse.m7.trading.api.v6.ContractPhaseType;
import com.deutscheboerse.m7.trading.api.v6.ContractStateType;
import com.deutscheboerse.m7.trading.api.v6.DlvryAreaStateListEntryType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.BooleanUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContractMapper
extends AbstractMapper<ContractListEntryType, Contract> {
    private static final Logger LOG = LoggerFactory.getLogger(ContractMapper.class);
    private final DataModel<String, Product> productDataModel;
    private final DataModel<String, DeliveryArea> deliveryAreaDataModel;
    private final DataModel<Long, Contract> contractDataModel;
    private final ContractQueries contractQueries;

    public ContractMapper(ApplicationContext applicationContext, Exchange exchange) {
        super(applicationContext, exchange, ContractListEntryType.class, Contract.class);
        this.productDataModel = applicationContext.getSmallDataModel(Product.class);
        this.deliveryAreaDataModel = applicationContext.getSmallDataModel(DeliveryArea.class);
        this.contractDataModel = applicationContext.getSmallDataModel(Contract.class);
        this.contractQueries = applicationContext.getService(ContractQueries.class);
    }

    @Override
    public Contract translate(ContractListEntryType from, MapperHandler mapperHandler, Object hint) {
        Contract contract = this.mapContractListEntryType(from);
        if (hint != null) {
            contract.setCorrelationId(hint.toString());
        }
        return contract;
    }

    protected Contract mapContractListEntryType(ContractListEntryType from) {
        Contract contract;
        String productId = from.getProd();
        Product product = this.productDataModel.findById(productId);
        if (product == null) {
            LOG.error("Product {} not found.", (Object)productId);
            return null;
        }
        boolean isBespokeContract = BooleanUtils.isTrue(from.isBespoke());
        boolean isBlockContract = !from.isPredefined() || product.getProductType() == ProductType.USER_DEFINED_DELIVERY_PERIOD;
        long contractId = from.getContractId();
        if (isBespokeContract) {
            BespokeContract bespokeContract = new BespokeContract(product, from.getUndrlngContracts().getContractId(), this.contractDataModel::findById);
            if (from.getStrikePx() != null && from.getCallPut() != null) {
                bespokeContract.setStrikePrc(product.mapPriceFromBackend(from.getStrikePx()));
                bespokeContract.setPutOrCall(this.mapCallPutContractType(from.getCallPut()));
            }
            contract = bespokeContract;
        } else {
            contract = isBlockContract ? (from.getUndrlngContracts() == null ? new BlockContract(product, () -> this.getUnderlyingContracts(contractId)) : new BlockContract(product, () -> new ArrayList<Long>(from.getUndrlngContracts().getContractId()).stream().map(this.contractDataModel::findById).filter(Objects::nonNull))) : new Contract(product);
        }
        CompoundStatus status = this.mapStatus(from.getDlvryAreaState(), from.getState(), from.getTradingPhase());
        contract.getCompoundStatus().merge(status);
        contract.setId(contractId);
        contract.setLongName(from.getLongName());
        contract.setName(from.getName());
        DateTimeZone timeZone = this.getExchange().getSystemInfo().getTimeZone();
        contract.setActivationPoint(DateTimeUtils.mapDateToDateTime(from.getActPoint(), timeZone));
        contract.setExpiryPoint(DateTimeUtils.mapDateToDateTime(from.getExpPoint(), timeZone));
        contract.setDeliveryEnd(DateTimeUtils.mapDateToDateTime(from.getDlvryEnd(), timeZone));
        contract.setDeliveryStart(DateTimeUtils.mapDateToDateTime(from.getDlvryStart(), timeZone));
        contract.setRevisionNumber(from.getRevisionNo());
        contract.setRemoteContractId(from.getRemoteContractId());
        return contract;
    }

    private Stream<Contract> getUnderlyingContracts(long contractId) {
        Contract contract = this.contractDataModel.findById(contractId);
        Product product = contract.getProduct().getProductType() == ProductType.USER_DEFINED_DELIVERY_PERIOD ? this.productDataModel.findById(contract.getProduct().getBaseProductId()) : contract.getProduct();
        return this.contractQueries.findByProduct(product).addFilter(c -> c.getType().isCanonical()).addFilter(c -> c.getDeliveryStart().compareTo(contract.getDeliveryStart()) >= 0).addFilter(c -> c.getDeliveryEnd().compareTo(contract.getDeliveryEnd()) <= 0).getAll();
    }

    private CompoundStatus mapStatus(List<DlvryAreaStateListEntryType> daStatusList, ContractStateType contractState, ContractPhaseType contractPhase) {
        CompoundStatus status = new CompoundStatus();
        this.mapContractStatus(status, contractState, contractPhase);
        for (DlvryAreaStateListEntryType dlvryAreaState : daStatusList) {
            DeliveryArea deliveryArea = this.deliveryAreaDataModel.findById(dlvryAreaState.getDlvryAreaId());
            if (deliveryArea == null) continue;
            status.setDeliveryAreaInfo(deliveryArea, this.mapDeliveryAreaInfo(dlvryAreaState));
        }
        return status;
    }

    private CompoundStatus.DeliveryAreaInfo mapDeliveryAreaInfo(DlvryAreaStateListEntryType dlvryAreaState) {
        ContractStatus daStatus = this.mapDeliveryAreaStatus(dlvryAreaState.getState());
        ContractPhase daPhase = this.mapDeliveryAreaPhase(dlvryAreaState.getTradingPhase());
        Interval activePeriod = null;
        DateTime start = DateTimeUtils.mapDateToDateTime(dlvryAreaState.getTradingPhaseStart(), this.getExchange().getSystemInfo().getTimeZone());
        DateTime end = DateTimeUtils.mapDateToDateTime(dlvryAreaState.getTradingPhaseEnd(), this.getExchange().getSystemInfo().getTimeZone());
        if (start != null && end != null && !end.isBefore(start)) {
            activePeriod = new Interval((ReadableInstant)start, (ReadableInstant)end);
        }
        return new CompoundStatus.DeliveryAreaInfo(daStatus, daPhase, activePeriod);
    }

    private ContractStatus mapDeliveryAreaStatus(ContractStateType daState) {
        if (daState == null) {
            return null;
        }
        return EnumMapper.mapContractStatus(daState);
    }

    private ContractPhase mapDeliveryAreaPhase(ContractPhaseType daPhase) {
        if (daPhase == null) {
            return null;
        }
        return EnumMapper.mapContractPhase(daPhase);
    }

    private void mapContractStatus(CompoundStatus compoundStatus, ContractStateType fromContractState, ContractPhaseType fromContractPhase) {
        if (fromContractState == null) {
            fromContractState = ContractStateType.IACT;
        }
        if (fromContractPhase == null) {
            fromContractPhase = ContractPhaseType.CLSD;
        }
        ContractStatus contractStatus = EnumMapper.mapContractStatus(fromContractState);
        compoundStatus.setContractStatus(contractStatus);
        compoundStatus.setTradingPhase(switch (contractStatus) {
            case ContractStatus.ACTI -> EnumMapper.mapContractPhase(fromContractPhase);
            default -> ContractPhase.CLSD;
        });
    }

    private PutOrCall mapCallPutContractType(CallPutContractType callPutContractType) {
        if (callPutContractType == null) {
            return null;
        }
        switch (callPutContractType) {
            case C: {
                return PutOrCall.CALL;
            }
            case P: {
                return PutOrCall.PUT;
            }
        }
        throw new IllegalArgumentException("Unknown callPutContractType: " + String.valueOf(callPutContractType));
    }
}

