/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.MarketState;
import com.deutscheboerse.comxerv.comtrader.entities.type.MarketStatus;
import com.deutscheboerse.comxerv.comtrader.service.mapper.AbstractMapper;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.m7.trading.api.v6.MarketStateType;
import com.deutscheboerse.m7.trading.api.v6.MktStateRprt;

public class MarketStateMapper
extends AbstractMapper<MktStateRprt, MarketState> {
    public MarketStateMapper(ApplicationContext applicationContext, Exchange exchange) {
        super(applicationContext, exchange, MktStateRprt.class, MarketState.class);
    }

    private MarketStatus mapMarketStatus(MarketStateType marketState) {
        if (marketState == null) {
            return null;
        }
        switch (marketState) {
            case ACTI: {
                return MarketStatus.ACTIVE;
            }
            case HIBE: {
                return MarketStatus.HIBERNATE;
            }
        }
        throw new IllegalArgumentException("Unknown market state: " + String.valueOf(marketState));
    }

    @Override
    public MarketState translate(MktStateRprt from, MapperHandler mapperHandler, Object hint) {
        MarketState marketState = new MarketState();
        marketState.setId(0);
        marketState.setStatus(this.mapMarketStatus(from.getState()));
        marketState.setRevisionNumber(from.getRevisionNo());
        if (hint != null) {
            marketState.setCorrelationId(hint.toString());
        }
        return marketState;
    }
}

