/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.type.ProductExecutionRestriction;
import com.deutscheboerse.comxerv.comtrader.entities.type.ProductState;
import com.deutscheboerse.comxerv.comtrader.entities.type.ProductType;
import com.deutscheboerse.comxerv.comtrader.service.mapper.AbstractMapper;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.m7.trading.api.type.ProductConfigurationConstants;
import com.deutscheboerse.m7.trading.api.v6.PrdExecType;
import com.deutscheboerse.m7.trading.api.v6.PrdType;
import com.deutscheboerse.m7.trading.api.v6.ProdCfg;
import com.deutscheboerse.m7.trading.api.v6.ProdStateType;
import com.deutscheboerse.m7.trading.api.v6.ProdType;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;

public class ProductMapper
extends AbstractMapper<ProdType, Product> {
    public ProductMapper(ApplicationContext applicationContext, Exchange exchange) {
        super(applicationContext, exchange, ProdType.class, Product.class);
    }

    @Override
    public Product translate(ProdType from, MapperHandler mapperHandler, Object hint) {
        Product.ProductBuilder product = new Product.ProductBuilder();
        product.withId(from.getProdName());
        product.withExchange(this.getExchange());
        product.withDisplayName(from.getDsplName());
        product.withQuantityUnit(from.getQtyUnit());
        product.withRevisionNumber(from.getRevisionNo());
        product.withCurrencyCode(from.getCurrency());
        product.withGlobalMarketId(from.getExchangeId());
        product.withTimezone(from.getTimeZone());
        int serverPriceDecimalShift = from.getDecShftPx();
        int clientPriceDecimalShift = Util.getMinimizedDecimalShift(serverPriceDecimalShift, from.getTickSize() == 1 ? (long)from.getTickSize() : (long)(from.getTickSize() / 2));
        product.withPriceDecimalShiftForBackend(serverPriceDecimalShift);
        product.withPriceDecimalShift(clientPriceDecimalShift);
        product.withPriceTickSize(new LongDisplayValue(from.getTickSize(), serverPriceDecimalShift).applyShift(clientPriceDecimalShift));
        product.withPriceMinValue(new LongDisplayValue(from.getMinPx(), serverPriceDecimalShift).applyShift(clientPriceDecimalShift));
        product.withPriceMaxValue(new LongDisplayValue(from.getMaxPx(), serverPriceDecimalShift).applyShift(clientPriceDecimalShift));
        int serverQtyDecimalShift = from.getDecShftQty();
        int clientQtyDecimalShift = Util.getMinimizedDecimalShift(serverQtyDecimalShift, from.getLotSize());
        product.withQuantityDecimalShiftForBackend(serverQtyDecimalShift);
        product.withQuantityDecimalShift(clientQtyDecimalShift);
        product.withQuantityMinValue(new LongDisplayValue(from.getMinQty(), serverQtyDecimalShift).applyRoundedUpShift(clientQtyDecimalShift));
        product.withQuantityLotSize(new LongDisplayValue(from.getLotSize(), serverQtyDecimalShift).applyShift(clientQtyDecimalShift));
        product.withQuantityMaxValue(new LongDisplayValue(from.getMaxQty(), serverQtyDecimalShift).applyShift(clientQtyDecimalShift));
        product.withAmountMaxValue(new LongDisplayValue(from.getMaxAmount(), serverPriceDecimalShift).applyShift(clientPriceDecimalShift));
        product.withProductType(this.mapProductType(from.getProdType()));
        product.withProductState(this.mapProductState(from.getState()));
        product.withDeliveryUnits(from.getDelUnits() == null ? 0.0 : from.getDelUnits());
        List<ProdCfg> prodCfgs = from.getProdCfgs();
        if (prodCfgs != null) {
            for (ProdCfg cfg : prodCfgs) {
                this.mapProductConfig(product, cfg, serverQtyDecimalShift, clientQtyDecimalShift, serverPriceDecimalShift, clientPriceDecimalShift);
            }
        }
        product.withLinkedProductId(from.getLinkedProd());
        product.withMasterProductId(from.getMasterProd());
        product.withIsBaseProduct(from.isBase());
        product.withIsLocationsEnabled(this.getExchange().getSystemInfo().supportsLocations() && BooleanUtils.isTrue(from.isLocationsEnabled()));
        product.withBaseProductId(from.getBaseReference());
        product.withGroupName(from.getGroupName());
        product.withExecutionRestriction(this.mapProductExecutionRestriction(from.getExecutionRestriction()));
        product.withRiskSetId(from.getRiskSetId());
        return product.build();
    }

    private ProductState mapProductState(ProdStateType from) {
        switch (from) {
            case ACTI: {
                return ProductState.ACTIVE;
            }
            case IACT: {
                return ProductState.INACTIVE;
            }
            case HIBE: {
                return ProductState.HIBERNATED;
            }
        }
        throw new IllegalArgumentException("Invalid ProdStateType: " + String.valueOf(from));
    }

    private void mapProductConfig(Product.ProductBuilder productBuilder, ProdCfg prodCfg, int serverQtyShift, int clientQtyShift, int serverPrcShift, int clientPrcShift) {
        if (ProductConfigurationConstants.ICEBERG_MIN_PEAK_SIZE.getKey().equals(prodCfg.getCfgKey())) {
            productBuilder.withIcebergMinPeakSize(new LongDisplayValue(Long.parseLong(prodCfg.getCfgVal()), serverQtyShift).applyShift(clientQtyShift).getValue());
        } else if (ProductConfigurationConstants.ICEBERG_PRICE_DELTA_RANGE.getKey().equals(prodCfg.getCfgKey())) {
            productBuilder.withIcebergDeltaRange(new LongDisplayValue(Long.parseLong(prodCfg.getCfgVal()), serverPrcShift).applyShift(clientPrcShift).getValue());
        } else if (ProductConfigurationConstants.QUOTE_MIN_QUANTITY.getKey().equals(prodCfg.getCfgKey())) {
            productBuilder.withMinQuoteQuantity(new LongDisplayValue(Long.parseLong(prodCfg.getCfgVal()), serverQtyShift).applyShift(clientQtyShift).getValue());
        } else if (ProductConfigurationConstants.ICEBERG_ORDER.getKey().equals(prodCfg.getCfgKey())) {
            productBuilder.withIcebergOrdersSupported(Boolean.parseBoolean(prodCfg.getCfgVal()));
        } else if (ProductConfigurationConstants.LIFT_ORDER_MATCHER.getKey().equals(prodCfg.getCfgKey())) {
            productBuilder.withLiftOrderProduct(Boolean.parseBoolean(prodCfg.getCfgVal()));
        } else if (ProductConfigurationConstants.LINKED_ORDER.getKey().equals(prodCfg.getCfgKey())) {
            productBuilder.withLinkedOrdersSupported(Boolean.parseBoolean(prodCfg.getCfgVal()));
        } else if (ProductConfigurationConstants.ON_EXCHANGE_PREARRANGED_TRADE.getKey().equals(prodCfg.getCfgKey())) {
            productBuilder.withOnExchangePrearrangedTrades(Boolean.parseBoolean(prodCfg.getCfgVal()));
        } else if (ProductConfigurationConstants.OTC_ONLY.getKey().equals(prodCfg.getCfgKey())) {
            productBuilder.withOtcOnly(Boolean.parseBoolean(prodCfg.getCfgVal()));
        } else if (ProductConfigurationConstants.OTC_ALLOWED.getKey().equals(prodCfg.getCfgKey())) {
            productBuilder.withOtcSupported(Boolean.parseBoolean(prodCfg.getCfgVal()));
        } else if (ProductConfigurationConstants.STOP_ORDER.getKey().equals(prodCfg.getCfgKey())) {
            productBuilder.withStopOrdersSupported(Boolean.parseBoolean(prodCfg.getCfgVal()));
        } else if (ProductConfigurationConstants.PRIVATE_AND_CONFIDENTIAL.getKey().equals(prodCfg.getCfgKey())) {
            productBuilder.withPrivateAndConfidential(Boolean.parseBoolean(prodCfg.getCfgVal()));
        } else if (ProductConfigurationConstants.QUOTE_ORDER.getKey().equals(prodCfg.getCfgKey())) {
            productBuilder.withQuoteOrderProduct(Boolean.parseBoolean(prodCfg.getCfgVal()));
        } else if (ProductConfigurationConstants.BLOCK_ORDER.getKey().equals(prodCfg.getCfgKey())) {
            productBuilder.withBlockOrderProduct(Boolean.parseBoolean(prodCfg.getCfgVal()));
        } else if (ProductConfigurationConstants.AUTO_ORDER_TRANSFER.getKey().equals(prodCfg.getCfgKey())) {
            productBuilder.withAotEnabled(Boolean.parseBoolean(prodCfg.getCfgVal()));
        }
    }

    private ProductType mapProductType(PrdType from) {
        switch (from) {
            case ENG: {
                return ProductType.ENERGY;
            }
            case COM: {
                return ProductType.COMMODITY;
            }
            case UDD: {
                return ProductType.USER_DEFINED_DELIVERY_PERIOD;
            }
        }
        throw new IllegalArgumentException("Invalid PrdType: " + String.valueOf(from));
    }

    private ProductExecutionRestriction mapProductExecutionRestriction(PrdExecType from) {
        switch (from) {
            case AON: {
                return ProductExecutionRestriction.ALL_OR_NOTHING;
            }
            case NON: {
                return ProductExecutionRestriction.PARTIAL_EXECUTION;
            }
        }
        throw new IllegalArgumentException("Invalid PrdExecType: " + String.valueOf((Object)from));
    }
}

