/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.datamodel.SmallFastDataModelBase;
import com.deutscheboerse.comxerv.comtrader.domain.query.OrderQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderStatus;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OrderDataModel
extends SmallFastDataModelBase<Long, Order> {
    public OrderDataModel(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    @Override
    public Class<Order> getEntityClass() {
        return Order.class;
    }

    @Override
    public Order add(Order order) {
        Order existingOrder = (Order)this.findById((Long)order.getId());
        if (existingOrder != null) {
            if (order.getStatus() == OrderStatus.INACTIVE) {
                this.remove(existingOrder);
                return null;
            }
            existingOrder.merge(order);
            return existingOrder;
        }
        this.appContext.getService(OrderQueries.class).findUnconfirmedByClientOrderId(order.getClientOrderId()).filter(o -> o.getStatus() == OrderStatus.SENT || o.getStatus() == OrderStatus.ERROR).ifPresent(this::remove);
        Order newOrder = new Order(order);
        if (newOrder.getStatus() == OrderStatus.INACTIVE) {
            return null;
        }
        if (newOrder.getOrderType() == OrderType.BESPOKE_PREARRANGED) {
            return null;
        }
        return super.add(newOrder);
    }

    @Override
    public Set<Order> addAll(Collection<Order> orders) {
        Map<Long, Order> ordersReduced = orders.stream().collect(Collectors.toMap(BroadcastEntity::getId, o -> o, (o1, o2) -> o1.getRevisionNumber() > o2.getRevisionNumber() ? o1 : o2));
        ArrayList<Order> ordersToRemove = new ArrayList<Order>();
        HashSet<Order> addedOrdes = new HashSet<Order>();
        for (Order order : ordersReduced.values()) {
            Order existingOrder = (Order)this.findById((Long)order.getId());
            if (existingOrder != null) {
                if (order.getStatus() == OrderStatus.INACTIVE) {
                    ordersToRemove.add(existingOrder);
                    continue;
                }
                existingOrder.merge(order);
                addedOrdes.add(existingOrder);
                continue;
            }
            this.appContext.getService(OrderQueries.class).findUnconfirmedByClientOrderId(order.getClientOrderId()).filter(o -> o.getStatus() == OrderStatus.SENT || o.getStatus() == OrderStatus.ERROR).ifPresent(this::remove);
            Order newOrder = new Order(order);
            if (newOrder.getStatus() == OrderStatus.INACTIVE || newOrder.getOrderType() == OrderType.BESPOKE_PREARRANGED) continue;
            addedOrdes.add(super.add(newOrder));
        }
        if (!ordersToRemove.isEmpty()) {
            this.removeAll(ordersToRemove);
        }
        return addedOrdes;
    }

    @Override
    protected boolean isNewerVersionOfExistingEntity(Order broadcastEntity, Order existingEntity) {
        return super.isNewerVersionOfExistingEntity(broadcastEntity, existingEntity) || this.isComtraderTriggeredOrderStatusChange(broadcastEntity, existingEntity) || this.isComtraderTriggeredOrderStatusChange(existingEntity, broadcastEntity);
    }

    private boolean isComtraderTriggeredOrderStatusChange(Order fromOrder, Order toOrder) {
        return fromOrder.getStatus() == OrderStatus.MODI && (toOrder.getStatus() == OrderStatus.ACTIVE || toOrder.getStatus() == OrderStatus.HIBERNATE) && fromOrder.getRevisionNumber() == toOrder.getRevisionNumber();
    }
}

