/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel.query;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataQuery;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.EntityFilters;
import com.deutscheboerse.comxerv.comtrader.datamodel.query.SmallFastDataModelQuery;
import com.deutscheboerse.comxerv.comtrader.datamodel.query.SortedSmallFastDataModelQuery;
import com.deutscheboerse.comxerv.comtrader.domain.query.ProductQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.type.ProductState;
import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
class ProductQueriesImpl
implements ProductQueries {
    private final SmallFastDataModel<String, Product> dataModel;

    @Inject
    public ProductQueriesImpl(ApplicationContext applicationContext) {
        this.dataModel = applicationContext.getSmallDataModel(Product.class);
    }

    @Override
    public DataQuery<Product> findActiveProductsByNameContains(String name) {
        return new SortedSmallFastDataModelQuery<String, Product>(this.dataModel, Product.DEFAULT_DISPLAY_COMPARATOR).addFilter(EntityFilters.containsIgnoreCase(Product::getDisplayName, name)).addFilter(product -> product.getProductState() == ProductState.ACTIVE);
    }

    @Override
    public DataQuery<Product> findActiveProductsByNameStart(String namePrefix) {
        return this.findProductsByNameStart(namePrefix).addFilter(product -> product.getProductState() == ProductState.ACTIVE);
    }

    @Override
    public DataQuery<Product> findActiveProductsByName(String name) {
        return this.findProductsByName(name).addFilter(product -> product.getProductState() == ProductState.ACTIVE);
    }

    @Override
    public DataQuery<Product> findProductsByNameStart(String namePrefix) {
        return new SortedSmallFastDataModelQuery<String, Product>(this.dataModel, Product.DEFAULT_DISPLAY_COMPARATOR).addFilter(EntityFilters.startsWithIgnoreCase(Product::getDisplayName, namePrefix));
    }

    @Override
    public DataQuery<Product> findProductsByName(String name) {
        return new SortedSmallFastDataModelQuery<String, Product>(this.dataModel, Product.DEFAULT_DISPLAY_COMPARATOR).addFilter(EntityFilters.equalsIgnoreCase(Product::getDisplayName, name));
    }

    @Override
    public DataQuery<Product> findProductsByBaseProductId(String baseProductId) {
        return new SmallFastDataModelQuery<String, Product>(this.dataModel).addFilter(p -> baseProductId != null && p.getBaseProductId() != null && baseProductId.equals(p.getBaseProductId()));
    }
}

