/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities.orderbook;

import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntrySource;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.entities.type.ExecutionRestriction;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import java.util.Comparator;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;

public class OrderbookEntry {
    private final Long orderId;
    private final LongDisplayValue price;
    private final LongDisplayValue quantity;
    private final DateTime time;
    private final OrderType orderType;
    private final OrderbookEntrySource source;
    private final LongDisplayValue remainingQuantity;
    private final ExecutionRestriction executionRestriction;
    private final long localTimestamp;
    private volatile boolean ownOrder;
    private volatile boolean ownUserOrder;

    protected OrderbookEntry(Long orderId, LongDisplayValue price, LongDisplayValue quantity, DateTime time, OrderType orderType, OrderbookEntrySource source, ExecutionRestriction executionRestriction, long localTimestamp) {
        this.orderId = orderId;
        this.price = price;
        this.quantity = quantity;
        this.time = time;
        this.orderType = orderType;
        this.source = source;
        this.executionRestriction = executionRestriction;
        this.remainingQuantity = quantity;
        this.localTimestamp = localTimestamp;
    }

    private OrderbookEntry(Builder builder) {
        this.orderId = builder.orderId;
        this.price = builder.price;
        this.quantity = builder.quantity;
        this.time = builder.time;
        this.orderType = builder.orderType;
        this.source = builder.source;
        this.remainingQuantity = builder.remainingQuantity;
        this.executionRestriction = builder.executionRestriction;
        this.localTimestamp = builder.localTimesamp;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Long getOrderId() {
        return this.orderId;
    }

    public LongDisplayValue getPrice() {
        return this.price;
    }

    public LongDisplayValue getQuantity() {
        return this.quantity;
    }

    public DateTime getTime() {
        return this.time;
    }

    public OrderType getOrderType() {
        return this.orderType;
    }

    public ExecutionRestriction getExecutionRestriction() {
        return this.executionRestriction;
    }

    public long getLocalTimestamp() {
        return this.localTimestamp;
    }

    public boolean isOwnOrder() {
        return this.ownOrder;
    }

    public void setOwnOrder(boolean ownOrder) {
        this.ownOrder = ownOrder;
    }

    public boolean isOwnUserOrder() {
        return this.ownUserOrder;
    }

    public void setOwnUserOrder(boolean ownUserOrder) {
        this.ownUserOrder = ownUserOrder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OrderbookEntry)) {
            return false;
        }
        OrderbookEntry that = (OrderbookEntry)o;
        return this.orderId.equals(that.orderId);
    }

    public int hashCode() {
        return this.orderId.hashCode();
    }

    private static int compareTime(OrderbookEntry o1, OrderbookEntry o2) {
        int timestampComparison = o1.time.compareTo(o2.time);
        return timestampComparison == 0 ? Long.compare(o1.getOrderId(), o2.getOrderId()) : timestampComparison;
    }

    public static Comparator<OrderbookEntry> getDefaultComparator(@Nonnull Direction direction) {
        return Direction.BUY.equals(direction) ? new OrderbookEntryPriceDescTimeAscComparator() : new OrderbookEntryPriceAscTimeAscComparator();
    }

    public String toString() {
        return "Entry{id='" + this.orderId + "', prc=" + String.valueOf(this.price) + ", qty=" + String.valueOf(this.quantity) + ", time=" + String.valueOf(this.time) + ", type=" + String.valueOf(this.orderType) + "}";
    }

    public boolean isTradable() {
        return true;
    }

    public OrderbookEntrySource getSource() {
        return this.source;
    }

    public LongDisplayValue getRemainingQuantity() {
        return this.remainingQuantity;
    }

    public static final class Builder {
        private Long orderId;
        private LongDisplayValue price;
        private LongDisplayValue quantity;
        private DateTime time;
        private OrderType orderType = OrderType.REGULAR;
        private OrderbookEntrySource source = OrderbookEntrySource.OUTRIGHT;
        private LongDisplayValue remainingQuantity;
        private ExecutionRestriction executionRestriction = ExecutionRestriction.NONE;
        private long localTimesamp = 0L;

        private Builder() {
        }

        public Builder withOrderId(Long orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder withPrice(LongDisplayValue price) {
            this.price = price;
            return this;
        }

        public Builder withQuantity(LongDisplayValue quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder withTime(DateTime time) {
            this.time = time;
            return this;
        }

        public Builder withOrderType(OrderType orderType) {
            this.orderType = orderType;
            return this;
        }

        public Builder withSource(OrderbookEntrySource source) {
            this.source = source;
            return this;
        }

        public Builder withRemainingQuantity(LongDisplayValue remainingQuantity) {
            this.remainingQuantity = remainingQuantity;
            return this;
        }

        public Builder withExecutionRestriction(ExecutionRestriction executionRestriction) {
            this.executionRestriction = executionRestriction;
            return this;
        }

        public Builder withLocalTimestamp(long localTimestamp) {
            this.localTimesamp = localTimestamp;
            return this;
        }

        public OrderbookEntry build() {
            this.time = this.time == null ? DateTime.now() : this.time;
            return new OrderbookEntry(this);
        }
    }

    public static class OrderbookEntryPriceDescTimeAscComparator
    implements Comparator<OrderbookEntry> {
        @Override
        public int compare(OrderbookEntry o1, OrderbookEntry o2) {
            int priceComparison = o2.getPrice().compareTo(o1.getPrice());
            return priceComparison == 0 ? OrderbookEntry.compareTime(o1, o2) : priceComparison;
        }
    }

    public static class OrderbookEntryPriceAscTimeAscComparator
    implements Comparator<OrderbookEntry> {
        @Override
        public int compare(OrderbookEntry o1, OrderbookEntry o2) {
            int priceComparison = o1.getPrice().compareTo(o2.getPrice());
            return priceComparison == 0 ? OrderbookEntry.compareTime(o1, o2) : priceComparison;
        }
    }
}

