/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities.type;

import com.deutscheboerse.comxerv.comtrader.core.util.DisplayName;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum NumberStyleType implements DisplayName
{
    EUROPEAN("commons_styletypeEuropean", Locale.GERMANY),
    AMERICAN("commons_styletypeAmerican", Locale.US);

    private final String displayNameLabel;
    private final Locale locale;
    private static Pattern patternEuropean;
    private static Pattern patternAmerican;

    private NumberStyleType(String displayNameLabel, Locale locale) {
        this.locale = locale;
        this.displayNameLabel = displayNameLabel;
    }

    private DecimalFormat createFormatter() {
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(this.locale);
        decimalFormat.setParseBigDecimal(true);
        decimalFormat.setDecimalSeparatorAlwaysShown(true);
        return decimalFormat;
    }

    public synchronized String format(BigDecimal bigDecimal, boolean groupingSeparator) {
        DecimalFormat decimalFormat = this.createFormatter();
        decimalFormat.setGroupingUsed(groupingSeparator);
        decimalFormat.setMinimumFractionDigits(bigDecimal.scale());
        if (bigDecimal.scale() == 0) {
            decimalFormat.setDecimalSeparatorAlwaysShown(false);
        } else {
            decimalFormat.setDecimalSeparatorAlwaysShown(true);
        }
        return decimalFormat.format(bigDecimal);
    }

    public BigDecimal parseNumberString(String numberString, boolean groupingSeparator) {
        ParsePosition parsePosition = new ParsePosition(0);
        DecimalFormat decimalFormat = this.createFormatter();
        decimalFormat.setGroupingUsed(groupingSeparator);
        BigDecimal parsedBigDecimal = (BigDecimal)decimalFormat.parse(numberString, parsePosition);
        if (groupingSeparator) {
            Matcher matcher;
            Matcher matcher2 = matcher = this.locale == Locale.US ? patternAmerican.matcher(numberString) : patternEuropean.matcher(numberString);
            if (!matcher.find()) {
                throw new NumberFormatException(numberString + " isn't correctly formatted");
            }
        }
        if (parsedBigDecimal == null || parsePosition.getIndex() < numberString.length()) {
            throw new NumberFormatException("Failed to parse: " + numberString);
        }
        return parsedBigDecimal;
    }

    @Override
    public String getDisplayName() {
        return Util.getLabel(this.displayNameLabel);
    }

    public DecimalFormat getDecimalFormat() {
        return this.createFormatter();
    }

    static {
        patternEuropean = Pattern.compile("^[+-]?(?!0(?!,)(?!$))([0-9]{1,3}(\\.[0-9]{3})*(,[0-9]+)?|\\d+,\\d+|\\d+)$");
        patternAmerican = Pattern.compile("^[+-]?(?!0(?!\\.)(?!$))([0-9]{1,3}(,[0-9]{3})*(\\.[0-9]+)?|\\d+\\.\\d+|\\d+)$");
    }
}

