/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.app.login.StorableComponent;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.AbstractDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.WeakDataModelListener;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ContractAdditionOrigin;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntryType;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookValueWrapper;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AbstractOrderbookPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.StorableBottomToolbarButton;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.CollapsibleValueOrderbookWrapper;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.OrderbookRemovalCallback;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.TabularOrderbookPanelState;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.CustomTableView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.OrderbookTableRow;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.storage.StorableTableLayoutDescriptor;
import com.deutscheboerse.comxerv.comtrader.jfx.service.csv.ImportExportService;
import com.deutscheboerse.comxerv.comtrader.jfx.util.TableUpdateManager;
import com.deutscheboerse.comxerv.comtrader.service.statistic.OwnVolumeStatisticsService;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradingSettingsService;
import com.deutscheboerse.ui.jfx.util.control.table.NoSelectionTableViewSelectionModel;
import com.deutscheboerse.ui.jfx.util.event.KeyEventUtil;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.collections.transformation.SortedList;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableView;
import javafx.scene.control.TitledPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.apache.commons.lang3.BooleanUtils;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TabularOrderbookPanel
extends AbstractOrderbookPanel<CollapsibleValueOrderbookWrapper, DeliveryArea>
implements StorableComponent<TabularOrderbookPanelState<CollapsibleValueOrderbookWrapper>> {
    private static final Logger LOG = LoggerFactory.getLogger(TabularOrderbookPanel.class);
    private final DataModelListener<Orderbook> orderbookDataModelListener;
    private final ImportExportService importExportService;
    private final TableUpdateManager tableUpdateManager;
    private final TradingSettingsService tradingSettingsService;
    private final OwnVolumeStatisticsService ownVolumeStatisticsService;
    @FXML
    protected TitledPane menu;
    @FXML
    protected CustomTableView<CollapsibleValueOrderbookWrapper> orderbookTableView;
    @FXML
    protected CheckBox aggregateCheckbox;

    protected TabularOrderbookPanel(ApplicationContext appContext, Predicate<Contract> contractFilter, Predicate<Product> productFilter) {
        super(appContext, contractFilter, productFilter);
        this.tableUpdateManager = appContext.getService(TableUpdateManager.class);
        this.importExportService = appContext.getService(ImportExportService.class);
        this.tradingSettingsService = appContext.getService(TradingSettingsService.class);
        this.ownVolumeStatisticsService = appContext.getService(OwnVolumeStatisticsService.class);
        this.orderbookDataModelListener = new AbstractDataModelListener<Orderbook>(){

            @Override
            public DataModelListener.NotificationResult notifyAdd(Orderbook object) {
                LOG.trace("Orderbook notifyAdd {}", (Object)object);
                TabularOrderbookPanel.this.tableUpdateManager.submitSortRequest(TabularOrderbookPanel.this.orderbookTableView);
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyUpdate(Orderbook object) {
                LOG.trace("Orderbook notifyUpdate {}", (Object)object);
                TabularOrderbookPanel.this.tableUpdateManager.submitSortRequest(TabularOrderbookPanel.this.orderbookTableView);
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }
        };
        this.addEventFilter(KeyEvent.KEY_PRESSED, (? super T keyEvent) -> {
            if (KeyEventUtil.isCtrlKeyCode(KeyCode.C, keyEvent)) {
                this.exportClipboard();
                keyEvent.consume();
            } else if (KeyEventUtil.isCtrlKeyCode(KeyCode.E, keyEvent)) {
                this.exportCSV();
                keyEvent.consume();
            }
        });
    }

    @Override
    public void updatedItem(Orderbook orderbook, Boolean compaundContractStatusChanged) {
        LOG.trace("Updating table triggered by {}, with compaund contract status changed: {}", (Object)orderbook, (Object)compaundContractStatusChanged);
        if (BooleanUtils.isTrue(compaundContractStatusChanged)) {
            this.refilterOrderbooks();
        } else {
            this.orderbookTableView.refresh();
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.filteredOrderbooks.addListener(change -> this.tableUpdateManager.submitSortRequest(this.orderbookTableView));
        SortedList sortedOrderbooks = new SortedList(this.filteredOrderbooks);
        this.orderbookTableView.setItems(sortedOrderbooks);
        sortedOrderbooks.comparatorProperty().bind(this.orderbookTableView.comparatorProperty());
        this.orderbookTableView.setSelectionModel(new NoSelectionTableViewSelectionModel<CollapsibleValueOrderbookWrapper>(this.orderbookTableView));
        this.orderbookTableView.setRowFactory(OrderbookTableRow.asOrderbookRowFactory(this.alertingService));
        SmallFastDataModel dataModel = this.getAppContext().getSmallDataModel(Orderbook.class);
        dataModel.registerListener(new WeakDataModelListener<Orderbook>(this.orderbookDataModelListener));
        this.aggregateCheckbox.selectedProperty().addListener((observable2, oldValue, newValue) -> this.applyAggregateToEachOrderbook());
        this.orderbooks.addListener(c -> this.applyAggregateToEachOrderbook());
    }

    private void applyAggregateToEachOrderbook() {
        this.orderbooks.forEach(orderbook -> orderbook.setType(this.aggregateCheckbox.isSelected() ? OrderbookEntryType.AGGREGATED : OrderbookEntryType.NOT_AGGREGATED));
        this.orderbookTableView.refresh();
    }

    @FXML
    public void expandAll() {
        for (CollapsibleValueOrderbookWrapper orderbookWrapper : this.orderbooks) {
            orderbookWrapper.setCollapsed(false);
        }
        this.refreshStorableBottomToolbarButtons(true);
    }

    @FXML
    public void collapseAll() {
        for (CollapsibleValueOrderbookWrapper orderbookWrapper : this.orderbooks) {
            orderbookWrapper.setCollapsed(true);
        }
        this.refreshStorableBottomToolbarButtons(false);
    }

    @Override
    public CollapsibleValueOrderbookWrapper getOrderbookItem(Orderbook orderbook, OrderbookRemovalCallback orderbookRemovalCallback, ContractAdditionOrigin origin) {
        return new CollapsibleValueOrderbookWrapper(orderbook, orderbookRemovalCallback, origin, this.limitChoiceBox.valueProperty(), !this.tradingSettingsService.isExpandMarketOverviewItemsOnAddingEnabled(), this.ownVolumeStatisticsService, this::orderbookValueWrapperChanged);
    }

    private void orderbookValueWrapperChanged(OrderbookValueWrapper orderbookValueWrapper) {
        Orderbook orderbook = orderbookValueWrapper.getOrderbook();
        if (orderbook != null && orderbook.getContractId() != null) {
            orderbookValueWrapper.setAlertingInfo(this.alertingService.getAlertingInfo(orderbook.getContractId(), orderbook.getDeliveryAreaId()));
        } else {
            orderbookValueWrapper.setAlertingInfo(null);
        }
    }

    @Override
    public void restoreComponentState(TabularOrderbookPanelState<CollapsibleValueOrderbookWrapper> componentState) {
        super.restoreComponentState(componentState.getOrderbookPanelState());
        componentState.getOrderbookTableDescriptor().applyToTable(this.orderbookTableView);
        this.bottomToolbar.applyToolbarItemState(componentState.getOrderbookPanelState().getBottomToolbarStoredState());
        this.menu.setExpanded(componentState.isMenuExpanded());
        Optional<StorableBottomToolbarButton> expandAll = this.getStorableBottomToolbarButton("expendAll");
        if (expandAll.isPresent() && expandAll.get().getState().booleanValue()) {
            this.expandAll();
        }
    }

    @Override
    public TabularOrderbookPanelState<CollapsibleValueOrderbookWrapper> getComponentState() {
        return new TabularOrderbookPanelState<CollapsibleValueOrderbookWrapper>(this.getBasicState(), StorableTableLayoutDescriptor.fromTable(this.orderbookTableView), this.menu != null && this.menu.isExpanded());
    }

    @FXML
    public void exportCSV() {
        this.importExportService.exportCollapsibleOrderbookToCsvFile(this.orderbookTableView, this.getScene().getWindow(), this.getFileName().replace(" ", "_"));
    }

    @FXML
    public void exportClipboard() {
        this.importExportService.exportCollapsibleOrderbookToClipboard(this.orderbookTableView);
    }

    private String getFileName() {
        LocalDate now = LocalDate.now();
        return now.toString("yyyy-MM-dd") + "-" + this.getComponentName();
    }

    private void refreshStorableBottomToolbarButtons(Boolean newState) {
        Optional<StorableBottomToolbarButton> expandAll = this.getStorableBottomToolbarButton("expendAll");
        Optional<StorableBottomToolbarButton> collapseAll = this.getStorableBottomToolbarButton("collapseAll");
        if (expandAll.isPresent()) {
            expandAll.get().restoreSavedState(newState);
        } else if (collapseAll.isPresent()) {
            collapseAll.get().restoreSavedState(newState == false);
        }
    }

    private Optional<StorableBottomToolbarButton> getStorableBottomToolbarButton(String id) {
        return this.bottomToolbar.getToolbarItems().stream().filter(i -> i.getId().equals(id)).map(b -> (StorableBottomToolbarButton)b).findFirst();
    }

    public TableView<CollapsibleValueOrderbookWrapper> getTableView() {
        return this.orderbookTableView;
    }
}

